--------------------------------------------------------------------------------
-- Easy HW "Hello world" test for LCD driver
--
-- Michal TRS
-- trsm1@fel.cvut.cz
--------------------------------------------------------------------------------
library IEEE;
Library UNISIM;
use UNISIM.vcomponents.all;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity lcd_hw_test2 is
  Port ( 
   CLK         :  in std_logic;
   AS_RESET_BTN:  in std_logic;
   RDY         : out std_logic;
   -- low level
   DATA        : out std_logic_vector(7 downto 0);
   RS          : out std_logic;
   RW          : out std_logic;
   E           : out std_logic
  );
end lcd_hw_test2;

architecture Behavioral of lcd_hw_test2 is

   signal as_reset   : std_logic;

   signal ascii   : std_logic_vector(7 downto 0);
   signal vld     : std_logic;
   signal oper    : std_logic_vector(1 downto 0);
   signal drv_rdy : std_logic;

   signal addr_in    : std_logic_vector(8 downto 0);
   signal addr_ce    : std_logic;
   signal addr_load  : std_logic;

   signal ram_addr   : std_logic_vector(8 downto 0);
   signal ram_out    : std_logic_vector(7 downto 0);
   signal ram_en     : std_logic;

   -- signal fetch_rdy  : std_logic;

   type st is (st_wait, st_initcnt, st_winitcnt, st_prefetch, st_fetch, st_presetcnt, st_setcnt, st_wsetcnt, st_write, st_wwrite, st_end);
   signal cur_state, next_state : st;

   component lcd
   Port (
      CLK         : in std_logic;
      AS_RESET    : in std_logic; 
      -- ------------------------
      OPER        : in std_logic_vector(1 downto 0);
      -- 00 - clear display
      -- 01 - return cursor home
      -- 10 - set DDRAM address
      -- 11 - write ASCII
      ASCII       : in std_logic_vector(7 downto 0);
      VLD         : in std_logic;
      RDY         : out std_logic;
      -- low level
      DATA        : out std_logic_vector(7 downto 0);
      RS          : out std_logic;
      RW          : out std_logic;
      E           : out std_logic);
   end component;


begin
   
   
   BUFG_inst : BUFG
   port map (
      O => as_reset,     -- Clock buffer output
      I => AS_RESET_BTN      -- Clock buffer input
   );


      RAMB4_S8_inst : RAMB4_S8
   generic map (                                                           
      INIT_00 => X"0000000000000000000000000000000000000000000000000020FF6F6C6C6548",  -- Hello
      INIT_01 => X"00000000000000000000000000000000000000000000000000FF21646C726F77",  -- world!
      INIT_02 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_03 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_04 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_05 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_06 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_07 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_08 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_09 => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0A => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0B => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0C => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0D => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0E => X"0000000000000000000000000000000000000000000000000000000000000000",
      INIT_0F => X"0000000000000000000000000000000000000000000000000000000000000000")

   port map (
      DO => ram_out,     -- 8-bit data output
      ADDR => ram_addr, -- 9-bit address input
      CLK => CLK,   -- Clock input
      DI => "00000000",     -- 8-bit data input
      EN => ram_en,     -- RAM enable input
      RST => '0',   -- Synchronous reset input
      WE => '0'      -- RAM write enable input
   );

   lcd_ctrl: lcd port map (
      CLK      => CLK,
      AS_RESET => AS_RESET,
      OPER     => oper,
      ASCII    => ascii,
      VLD      => vld,
      RDY      => drv_rdy,
      DATA     => DATA,
      RS       => RS,
      RW       => RW,
      E        => E
   );

   RDY <= drv_rdy;


   addr_gen: process(CLK, AS_RESET)
   begin
      if AS_RESET = '1' then
         ram_addr   <= (others => '0');
      elsif CLK = '1' and CLK'event then
         if addr_load = '1' then
            ram_addr <= addr_in;
         elsif addr_ce = '1' then
            ram_addr <= ram_addr + '1';
         end if;
      end if;
   end process;  


--   process(CLK, AS_RESET)
--   begin
--      if AS_RESET = '1' then 
--         fetch_rdy = '0';
--      elsif CLK = '1' and CLK'event then
--         fetch_rdy <= addr_ce;
--      end if;
--   end process;


   SYNC_PROC: process (CLK, AS_RESET)
   begin
      if AS_RESET = '1' then
         cur_state <= st_wait;
      elsif CLK'event and CLK = '1' then
         cur_state <= next_state;
      end if;
   end process;

 
   NEXT_STATE_DECODE: process (cur_state,drv_rdy,ram_out)
   begin
      next_state <= cur_state;
      
      case (cur_state) is
         when st_wait =>
            if drv_rdy = '1' then
               next_state <= st_initcnt; 
            end if;
         when st_initcnt =>
            next_state <= st_winitcnt;
         when st_winitcnt =>
            if drv_rdy = '1' then
               next_state <= st_fetch;
            end if;
         when st_prefetch =>
            next_state <= st_fetch;
         when st_fetch =>
            if ram_out = X"00" then -- jmp, prectu adresu
               next_state <= st_presetcnt;
            elsif ram_out = X"FF" then -- konec
               next_state <= st_end;
            else                   -- ascii => vypisu
               next_state <= st_write;
            end if;
         when st_write =>
            next_state <= st_wwrite;
         when st_wwrite =>
            if drv_rdy = '1' then
               next_state <= st_prefetch;
            end if;
         when st_presetcnt =>
            next_state <= st_setcnt;
         when st_setcnt =>
            next_state <= st_wsetcnt;
         when st_wsetcnt => 
            if drv_rdy = '1' then 
               next_state <= st_prefetch;
            end if;
         when st_end =>
            null;
      end case;      
   end process;

 
   OUTPUT_DECODE: process (cur_state,drv_rdy, ram_out)
   begin
      -- default values
      -----------------

      -- signals for low level
      ascii <= (others => '0');
      oper  <= "11";
      vld   <= '0';
      
      -- BlockRam read
      ram_en   <= '0';

      -- addres generator
      addr_load <= '0';
      addr_ce   <= '0';
      addr_in   <= (others => '0');

      case (cur_state) is
         when st_initcnt =>
            -- return cursor home & set DDRAM addr to 0
            oper  <= "01";
            vld   <= '1';
            addr_in     <= (others => '0');   
            addr_load   <= '1';
            ram_en <= '1';
         when st_fetch =>          
            if ram_out = X"00" then -- jmp, prectu adresu
               addr_ce  <= '1';
               ram_en <= '1';
            elsif ram_out = X"FF" then -- konec
               null;
            else                   -- ascii => vypisu
               ascii <= ram_out;
               oper  <= "11";
               vld   <= '1';
            end if;
         when st_write =>
            ascii <= ram_out;
            oper  <= "11";
            vld   <= '1';    
         when st_wwrite =>
            if drv_rdy = '1' then
               addr_ce <= '1';
               ram_en <= '1';
            end if;
         when st_setcnt => 
            ascii <= ram_out;
            oper  <= "10";
            vld   <= '1';    
            addr_in(7 downto 0) <= ram_out;
            addr_load <= '1';
            addr_ce <= '1';
            ram_en <= '1';
         when others =>
             null;
      end case;      
   end process;

end Behavioral;
