--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:    11:33:37 04/11/06
-- Design Name:    
-- Module Name:    stopky - Behavioral
-- Project Name:   
-- Target Device:  
-- Tool versions:  
-- Description:
--
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity stopky is
   generic (
      del_mod_msb    : natural := 1  -- delicka MSB
   );
   Port ( 
      CLK :     in  std_logic;
      AS_RESET: in  std_logic;
      BTN  :    in  std_logic;
      DSWITCH : in  std_logic;

      -- 7 segment display
      ANODES :  out std_logic_vector(6 downto 0); -- abcdefg
      CAT1 :    out std_logic;
      CAT2 :    out std_logic 
   );
end stopky; 

architecture Behavioral of stopky is

   signal iclk          : std_logic; -- cnt_delic = 0 
   signal delicka       : std_logic_vector(del_mod_msb downto 0);
   
   signal btn_reg       : std_logic;      
   signal btn_reg2      : std_logic;      
   signal btn_pressed   : std_logic;

   -- common counter signals
   signal cnt_ce        : std_logic;
   signal cnt_res       : std_logic;

   -- BCD counters
   signal ms_cnt        : std_logic_vector(7 downto 0); -- 99
   signal sec_cnt       : std_logic_vector(7 downto 0); -- 59
   
   signal sec           : std_logic;
   signal min           : std_logic;

   -- mux
   signal dec_in        : std_logic_vector(7 downto 0);
   signal switch_reg    : std_logic;
   signal switch_reg2   : std_logic;
   signal switch_pressed: std_logic;
   signal mux_sel       : std_logic;

   -- 7 seg
   signal digit         : std_logic_vector(3 downto 0);

   -- control FSM
   type t_state is (st_start, st_stop, st_clear); 
   signal cur_state, next_state : t_state; 

begin
-- ----------------------------------------------
--    
   b_reg1: process(CLK,AS_RESET)
   begin
      if AS_RESET = '1' then
         btn_reg <= '0';
      elsif CLK = '1' and CLK'event then
         btn_reg <= BTN;
      end if; 
   end process;

   b_reg2: process(CLK,AS_RESET)
   begin
      if AS_RESET = '1' then
         btn_reg2 <= '0';
      elsif CLK = '1' and CLK'event then
         btn_reg2 <= btn_reg;
      end if; 
   end process;
   
   btn_pressed <= btn_reg2 and not btn_reg;
   

   SYNC_PROC: process (CLK, AS_RESET)
   begin
      if (AS_RESET = '1') then
            cur_state <= st_clear;
      elsif (CLK'event and CLK = '1') then
         cur_state <= next_state;
      end if;
   end process;
 
   --MOORE State Machine - Outputs based on state and inputs
   OUTPUT_DECODE: process (cur_state)
   begin
      cnt_ce  <= '0';
      cnt_res <= '0';

      case cur_state is
         when st_start =>
            cnt_ce <= '1';
         when st_stop =>
            null;
         when st_clear =>
            cnt_res <= '1';
      end case;    
   end process;
 
   NEXT_STATE_DECODE: process (cur_state, btn_pressed)
   begin
      next_state <= cur_state;  
      case (cur_state) is
         when st_start =>
            if btn_pressed = '1' then
               next_state <= st_stop;
            end if;
         when st_stop =>
            if btn_pressed = '1' then
               next_state <= st_clear;
            end if;
         when st_clear =>
            if btn_pressed = '1' then
               next_state <= st_start;
            end if;
      end case;      
   end process;


   div: process(CLK, AS_RESET)
   begin
      if AS_RESET = '1' then
         delicka <= (others => '0');
      elsif CLK = '1' and CLK'event then
         delicka <= delicka + 1;
      end if;
   end process;
  
   iclkgen: process(CLK, AS_RESET)
   begin
      if AS_RESET = '1' then
         iclk <= '0';
      elsif CLK = '1' and CLK'event then 
         if delicka = conv_std_logic_vector(0, del_mod_msb) then
            iclk <= not iclk;
         end if;
      end if;
   end process;

  
   mscnt: process(iclk)
   begin
      if iclk = '1' and iclk'event then
         if cnt_res = '1' or sec = '1' then 
            ms_cnt <= (others => '0');
         elsif cnt_ce = '1' then
            ms_cnt(3 downto 0) <= ms_cnt(3 downto 0) + '1';
            if ms_cnt(3 downto 0) = "1001" then 
               ms_cnt(3 downto 0) <= (others => '0');
               ms_cnt(7 downto 4) <= ms_cnt(7 downto 4) + '1';
            end if;
         end if;
      end if;
   end process;

   sec <= '1' when ms_cnt = "10011001"
     else '0';

   seccnt: process(iclk)
   begin
      if iclk = '1' and iclk'event then
         if cnt_res = '1' or min = '1' then 
            sec_cnt <= (others => '0');
         elsif cnt_ce = '1' and sec = '1' then
            sec_cnt(3 downto 0) <= sec_cnt(3 downto 0) + '1';
            if sec_cnt(3 downto 0) = "1001" then
               sec_cnt(3 downto 0) <= (others => '0');
               sec_cnt(7 downto 4) <= sec_cnt(7 downto 4) + '1';
            end if;
         end if;
      end if;
   end process;
      
   min <= '1' when sec_cnt = "01100000"
     else '0';


   s_reg1: process(CLK,AS_RESET)
   begin
      if AS_RESET = '1' then
         switch_reg <= '0';
      elsif CLK = '1' and CLK'event then
         switch_reg <= DSWITCH;
      end if; 
   end process;

   s_reg2: process(CLK,AS_RESET)
   begin
      if AS_RESET = '1' then
         switch_reg2 <= '0';
      elsif CLK = '1' and CLK'event then
         switch_reg2 <= switch_reg;
      end if; 
   end process;
   
   switch_pressed <= switch_reg2 and not switch_reg;  

   process(CLK, AS_RESET)
   begin
      if AS_RESET = '1' then
         mux_sel <= '1';
      elsif CLK = '1' and CLK'event then
         if switch_pressed = '1' then         
            mux_sel <= not mux_sel;
         else
            mux_sel <= mux_sel;
         end if;
      end if;
   end process;


   process(mux_sel, ms_cnt, sec_cnt)
   begin
      if mux_sel = '0' then
         dec_in <= ms_cnt;
      else
         dec_in <= sec_cnt;
      end if;
   end process;

   segdec: process (CLK, dec_in)
   begin
      CAT1 <= '0';
      CAT2 <= '0'; 
      
      if CLK = '1' then -- 1.cislice
         digit <= dec_in(7 downto 4);
         CAT1 <= '1';
      else              -- 2.cislice
         digit <= dec_in(3 downto 0);
         CAT2 <= '1';
      end if;

      case digit is
         when "0000" => ANODES <= "1111110";
         when "0001" => ANODES <= "0110000";
         when "0010" => ANODES <= "1101101";
         when "0011" => ANODES <= "1111001";
         when "0100" => ANODES <= "0110011";
         when "0101" => ANODES <= "1011011";
         when "0110" => ANODES <= "1011111";
         when "0111" => ANODES <= "1110000";
         when "1000" => ANODES <= "1111111";
         when "1001" => ANODES <= "1111011";
         when others => ANODES <= "0000000";
      end case;      
   end process;

end Behavioral;
