
--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   10:42:58 11/22/2006
-- Design Name:   cpu_ent
-- Module Name:   cpu_tb.vhd
-- Project Name:  CPU
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: cpu_ent
--
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends 
-- that these types always be used for the top-level I/O of a design in order 
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;

ENTITY cpu_tb_vhd IS
END cpu_tb_vhd;

ARCHITECTURE behavior OF cpu_tb_vhd IS 

	-- Component Declaration for the Unit Under Test (UUT)
	COMPONENT cpu
	PORT(
		CLK50 : IN std_logic;
		RESET : IN std_logic;
		SRAM_TX_ACK : IN std_logic;
		SRAM_RX_DATA : IN std_logic_vector(7 downto 0);
		SRAM_RX_VALID : IN std_logic;
		COM_TX_ACK : IN std_logic;
		COM_RX_DATA : IN std_logic_vector(7 downto 0);
		COM_RX_VALID : IN std_logic;
		GPS_TX_ACK : IN std_logic;
		GPS_RX_DATA : IN std_logic_vector(7 downto 0);
		GPS_RX_VALID : IN std_logic;
		GLCD_TX_ACK : IN std_logic;          
		SRAM_TX_DATA : OUT std_logic_vector(7 downto 0);
		SRAM_TX_VALID : OUT std_logic;
		SRAM_RX_ACK : OUT std_logic;
		COM_TX_DATA : OUT std_logic_vector(7 downto 0);
		COM_TX_VALID : OUT std_logic;
		COM_RX_ACK : OUT std_logic;
		GPS_TX_DATA : OUT std_logic_vector(7 downto 0);
		GPS_TX_VALID : OUT std_logic;
		GPS_RX_ACK : OUT std_logic;
		GLCD_TX_DATA : OUT std_logic_vector(7 downto 0);
		GLCD_TX_VALID : OUT std_logic
		);
	END COMPONENT;

	--Inputs
	SIGNAL CLK50 :  std_logic := '0';
	SIGNAL RESET :  std_logic := '0';
	SIGNAL SRAM_TX_ACK :  std_logic := '0';
	SIGNAL SRAM_RX_VALID :  std_logic := '0';
	SIGNAL COM_TX_ACK :  std_logic := '0';
	SIGNAL COM_RX_VALID :  std_logic := '0';
	SIGNAL GPS_TX_ACK :  std_logic := '0';
	SIGNAL GPS_RX_VALID :  std_logic := '0';
	SIGNAL GLCD_TX_ACK :  std_logic := '0';
	SIGNAL SRAM_RX_DATA :  std_logic_vector(7 downto 0) := (others=>'0');
	SIGNAL COM_RX_DATA :  std_logic_vector(7 downto 0) := (others=>'0');
	SIGNAL GPS_RX_DATA :  std_logic_vector(7 downto 0) := (others=>'0');

	--Outputs
	SIGNAL SRAM_TX_DATA :  std_logic_vector(7 downto 0);
	SIGNAL SRAM_TX_VALID :  std_logic;
	SIGNAL SRAM_RX_ACK :  std_logic;
	SIGNAL COM_TX_DATA :  std_logic_vector(7 downto 0);
	SIGNAL COM_TX_VALID :  std_logic;
	SIGNAL COM_RX_ACK :  std_logic;
	SIGNAL GPS_TX_DATA :  std_logic_vector(7 downto 0);
	SIGNAL GPS_TX_VALID :  std_logic;
	SIGNAL GPS_RX_ACK :  std_logic;
	SIGNAL GLCD_TX_DATA :  std_logic_vector(7 downto 0);
	SIGNAL GLCD_TX_VALID :  std_logic;

	constant T : time := 50 ns;

	type t_mem is array(0 to 500) of std_logic_vector(7 downto 0);

BEGIN

	-- Instantiate the Unit Under Test (UUT)
	uut: cpu PORT MAP(
		CLK50 => CLK50,
		RESET => RESET,
		SRAM_TX_DATA => SRAM_TX_DATA,
		SRAM_TX_VALID => SRAM_TX_VALID,
		SRAM_TX_ACK => SRAM_TX_ACK,
		SRAM_RX_DATA => SRAM_RX_DATA,
		SRAM_RX_VALID => SRAM_RX_VALID,
		SRAM_RX_ACK => SRAM_RX_ACK,
		COM_TX_DATA => COM_TX_DATA,
		COM_TX_VALID => COM_TX_VALID,
		COM_TX_ACK => COM_TX_ACK,
		COM_RX_DATA => COM_RX_DATA,
		COM_RX_VALID => COM_RX_VALID,
		COM_RX_ACK => COM_RX_ACK,
		GPS_TX_DATA => GPS_TX_DATA,
		GPS_TX_VALID => GPS_TX_VALID,
		GPS_TX_ACK => GPS_TX_ACK,
		GPS_RX_DATA => GPS_RX_DATA,
		GPS_RX_VALID => GPS_RX_VALID,
		GPS_RX_ACK => GPS_RX_ACK,
		GLCD_TX_DATA => GLCD_TX_DATA,
		GLCD_TX_VALID => GLCD_TX_VALID,
		GLCD_TX_ACK => GLCD_TX_ACK
	);

	CLK50 <= not CLK50 after T;


	sram_model: process
		variable mem: t_mem;
		variable rd_addr	: integer := 0;
		variable wr_addr	: integer := 0;
	begin
		wait until SRAM_TX_VALID='1' or GPS_TX_VALID='1';
		if GPS_TX_VALID='1' then -- zapis dat do pameti
			mem(wr_addr) := GPS_TX_DATA;
			wr_addr := wr_addr + 1;
			wait for 3*T;
			GPS_TX_ACK <= '1';
			wait until GPS_TX_VALID='0';
			wait for 3*T;
			GPS_TX_ACK <= '0';	
		else --if SRAM_TX_VALID='1' then
			if SRAM_TX_DATA = X"A5" then 				
				wait for 3*T;
			  	SRAM_TX_ACK <= '1';
				wait until SRAM_TX_VALID='0';
				wait for 3*T;
				SRAM_TX_ACK <= '0';

				for i in 0 to wr_addr-1 loop
					if SRAM_RX_ACK = '1' then
					   wait until SRAM_RX_ACK = '0';
					end if;   
					wait for 2*T;
					SRAM_RX_DATA <= mem(rd_addr);
				   rd_addr := rd_addr + 1;
					SRAM_RX_VALID <= '1';
					wait until SRAM_RX_ACK = '1';
					wait for 2*T;
					SRAM_RX_VALID <= '0';
				end loop;
				-- poslu A5 konec
				wait until SRAM_RX_ACK = '0';
				wait for 2*T;
				SRAM_RX_DATA <= X"A5";
			   rd_addr := 0;
				wr_addr := 0;
				SRAM_RX_VALID <= '1';
				wait until SRAM_RX_ACK = '1';
				wait for 2*T;
				SRAM_RX_VALID <= '0';
			end if;
		end if;
	end process;


	tb : PROCESS
	BEGIN

		-- Wait 100 ns for global reset to finish
		reset <= '1';
		wait for 100 ns;
		reset <= '0';
		wait for 1 us;

		-- Place stimulus here

		com_rx_data <= X"31";
		com_rx_valid <= '1';
		wait until com_rx_ack = '1';
		wait for 100 ns;
		com_rx_valid <= '0';		
		wait for 3*T;

		com_rx_data <= X"32";
		com_rx_valid <= '1';
		wait until com_rx_ack = '1';
		wait for 100 ns;
		com_rx_valid <= '0';		
		wait for 3*T;

		com_rx_data <= X"65";
		com_rx_valid <= '1';
		wait until com_rx_ack = '1';
		wait for 100 ns;
		com_rx_valid <= '0';		
		wait for 3*T;

		com_rx_data <= X"66";
		com_rx_valid <= '1';
		wait until com_rx_ack = '1';
		wait for 100 ns;
		com_rx_valid <= '0';		
		wait for 3*T;

		-- 
		com_rx_data <= X"67";
		com_rx_valid <= '1';
		wait until com_rx_ack = '1';
		wait for 100 ns;
		com_rx_valid <= '0';		
		wait for 3*T;

	  	-- end 'q'
		com_rx_data <= X"71";
		com_rx_valid <= '1';
		wait until com_rx_ack = '1';
		wait for 100 ns;
		com_rx_valid <= '0';		
		wait for 3*T;

		-- read from mem
		wait until com_tx_valid = '1';
		wait for 100 ns;
		com_tx_ack <= '1';		
		wait until com_tx_valid = '0';
		wait for 100 ns;
		com_tx_ack <= '0';	
		
		wait until com_tx_valid = '1';
		wait for 100 ns;
		com_tx_ack <= '1';		
		wait until com_tx_valid = '0';
		wait for 100 ns;
		com_tx_ack <= '0';
		
		wait until com_tx_valid = '1';
		wait for 100 ns;
		com_tx_ack <= '1';		
		wait until com_tx_valid = '0';
		wait for 100 ns;
		com_tx_ack <= '0';
		
		wait until com_tx_valid = '1';
		wait for 100 ns;
		com_tx_ack <= '1';		
		wait until com_tx_valid = '0';
		wait for 100 ns;
		com_tx_ack <= '0';	

		wait; -- will wait forever
	END PROCESS;

END;
