

package net.michaltrs;

import java.util.*;
import javax.swing.*;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.RemoteException;
import java.io.*;

public class RoutingTable extends UnicastRemoteObject implements RoutingTableInterface {
    public RoutingTable() throws RemoteException {
        super();
        System.setProperty("java.rmi.server.codebase",
           "file:c:\\skola\\7.semestr\\36DSY\\ulohy\\rmi_rip\\Rip\\classes\\");
    }

    private Map table = new HashMap();
    private String name = null;

    public void setName(String name) {
        this.name = name;
    }


    public void AddItem(String addr, String gw, int dist) {
        if (table.containsKey(addr))
            table.remove(addr);

            TableItem ti = new TableItem();

            ti.brana = gw;
            ti.vzdalenost = dist;
            table.put(addr, ti);
            saveTable();
    }

    public boolean RemoveItem(String addr) {
        if (table.containsKey(addr)) {
            table.remove(addr);
            return true;
        } else
            return false;
    }

    public void ChangeItem(String addr, String gw, int dist) {

        if (table.containsKey(addr)) {
            table.remove(addr);
            AddItem(addr,gw,dist);
        } else
            AddItem(addr,gw,dist);
    }

    public void printTable(JTextArea textArea) {
        textArea.setText("");
        textArea.append("addr\tgw\tdist\n");

        Object[] keys = table.keySet().toArray();
        Object[] val = table.values().toArray();
    //       Arrays.sort(keys);
        for (int i = 0; i < keys.length; i++) {
            textArea.append(keys[i] + "\t" + val[i] + "\n");
        }
    }

    public void printAddresses(JList list) {
        Object [] keys = table.keySet().toArray();
        Arrays.sort(keys);
        list.setListData(keys);
    }

    public boolean isEmpty() {
        return table.isEmpty();
    }

    public Map getTable(String name) {
       Map m = loadTable(name);
       System.out.println(m.size());
       System.out.println(m.keySet());
       return m;
    }

    public void saveTable() {
        try {
            FileOutputStream out = new FileOutputStream(name);
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(table);
            s.flush();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Map loadTable(String name) {
        try {
            FileInputStream in = new FileInputStream(name);
            ObjectInputStream s = new ObjectInputStream(in);
            return (Map) s.readObject();
        } catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }

    }

    public void UpdateTable(Map [] neighboursTab,Map localTab, String localAddr) {
        String[] owners = new String[neighboursTab.length];

        // pro kazdou smerovaci tabulku souseda...
        for (int i=0; i < neighboursTab.length; i++) {
            String[] keys = RipFrame.ReCast(neighboursTab[i].keySet().toArray());
            // pro kazdy jeji prvek...
            for (int j = 0; j < keys.length; j++) {
                TableItem ti = (TableItem) neighboursTab[i].get(keys[j]);
                if (ti.vzdalenost == 0) owners[i] = keys[j]; // najdi vlastnika
            }
        }

        // vyprazdnim dosavadni tabulku
        table.clear();
        AddItem(localAddr,localAddr,0); // localhost

        // pro kazdkou tabulku gw
        for (int i = 0; i < neighboursTab.length; i++) {
            Map curGwTab = neighboursTab[i];
            String[] cgtkeys = RipFrame.ReCast(curGwTab.keySet().toArray());
            Integer vzdOvnToGw = (Integer) localTab.get(owners[i]);
            // pro kazdy zaznam v tabulce
            for (int j = 0; j < curGwTab.size(); j++) {
                TableItem ti = (TableItem) curGwTab.get(cgtkeys[j]);
                ti.vzdalenost += vzdOvnToGw.intValue();
                ti.brana = owners[i];

                if (!table.containsKey(cgtkeys[j]))
                    // neobsahuje klic - pridej
                    table.put(cgtkeys[j], ti);
                else {
                    TableItem last = ((TableItem) table.get(cgtkeys[j]));
                    if (ti.vzdalenost < last.vzdalenost) {
                        RemoveItem(cgtkeys[j]);
                        table.put(cgtkeys[j],ti);
                    }
                }
            }
        }

        // odeber klic se vzd >= 32
        String[] k = RipFrame.ReCast(table.keySet().toArray());
        for (int i = 0; i < k.length; i++) {
            if ( ((TableItem)table.get(k[i])).vzdalenost >= 32 )
                RemoveItem(k[i]);
        }

        saveTable();
    }




    public void startServer(String localAddr) {
        try {
           //System.setProperty("java.rmi.server.codebase",
           //"file:c:\\skola\\7.semestr\\36DSY\\ulohy\\rmi_rip\\Rip\\classes\\");
           Naming.rebind("//localhost:1919/" + localAddr, new RoutingTable());
           System.out.println("successfully bound!");
       } catch (Exception ex) {
           ex.printStackTrace();
       }
    }


}



