using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace FTPParser
{
    class CSVReader
    {
        private const char CARRIER = '"';
        
        private StreamReader sr;


        public CSVReader(string file)
        {
            sr = new StreamReader(file);
        }

        public string ReadLine()
        {
            string line = sr.ReadLine();

            // read whole data
            while (!line.EndsWith(CARRIER.ToString()))
            {
                string nl = sr.ReadLine().Trim();
                if (nl != "")
                {
                    line += ";" + nl;    
                }                
            }

            // remove CARRIER
            while (line.Contains(CARRIER.ToString()))
            {
                line = line.Remove(line.IndexOf(CARRIER), 1);
            }

            line += Environment.NewLine;

            return line;
        }


        public void Close()
        {
            sr.Close();
        }

        public bool EndOfStream()
        {
            return sr.EndOfStream;
        }
    }
}
