/* ========================================================================== */
/*                                                                            */
/*   psort_v1.c                                                               */
/*   (c) 2005 Michal Trs, trsm1@fel.cvut.cz                                   */
/*                                                                            */
/*   Description: Semestralni prace na predmet OSY, prubezny sort             */
/*                vstupni parametry: u, v, c                                  */
/* ========================================================================== */


#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#define MAX 100


/* implementace prioritni fronty */

typedef struct prvek {
  int value;
  struct prvek *next;
} PRVEK; 

PRVEK *first = NULL;

int AddToQ(int value) {
  PRVEK *tmp, *akt, *pr;
  int index = 0;
  
  if ((tmp = (PRVEK*) malloc(sizeof(PRVEK))) == NULL) 
    return (1);
  else
    tmp->value = value;
    
  if (first == NULL) { /*fronta je prazdna => vytvoreni nove*/
    first = tmp;
    tmp->next = NULL;    
  } 
  else if (first->value > value) { /* vkladany je nejmensi */
    tmp->next = first;
    first = tmp;
  } 
  else { 
    /*najdi pozici ve fronte pro ulozeni*/    
    akt = first; pr = NULL;
    while ( (akt != NULL) && (akt->value <= value) )  {
      pr = akt;
      akt = akt->next;
    }
    
    if (pr == NULL) {
     tmp->next = akt->next;
     akt->next = tmp;          
    } else {
     /*vlozeni*/
     tmp->next = pr->next;
     pr->next = tmp;
    } 
  }
  return (0);
}

int RemFromQ(int *value) { /*fce vraci 0 pokud byl ve fronte prvek*/
  PRVEK *tmp;  

  if (first == NULL) return (2); /*fronta prazdna*/
  
  tmp = first;
  first = first->next;
  
  *value = tmp->value;
  free((void*)tmp);
  return (0);
}

/************* EO Fronta **************/





int main(int argc, char *argv[])
{
  int     fdPS[2], fdSC[2], rnd;
  pid_t   pidS, pidP;
  int i;
  int u,v,c;
  int count = 0;

/* osetreni vstupnich parametru */

	switch (argc) {
	  case 2 : 
	    if ( (!strcmp(argv[1],"-h")) || (!strcmp(argv[1],"--help")) ) {
       printf("Program prubezny sort - semestralka na OSY\n");
	     printf("vsechny parametry nutno zadat!!\n");
	     printf("Parametry:\t [-u x]\t\t x pocet komparaci za 1s\n");
	     printf("\t\t [-v n]\t\t n pocet generovanych nahodnych cisel za 1s\n");
	     printf("\t\t [-c count]\t count pocet generovanych cisel v P\n\n"); 
	     printf("Autor programu: Michal Trs, trsm1@fel.cvut.cz\n");
	    }
	    return (0);
      break;

    case 7 :
      for (i=1; i < 7; i+=2)
        if (!strcmp(argv[i],"-u"))
          u = atoi(argv[i+1]);
        else if (!strcmp(argv[i],"-v"))
          v = atoi(argv[i+1]);
        else if (!strcmp(argv[i],"-c"))
          c = atoi(argv[i+1]);
        else {
          printf("Chybny parametr!  Pro napovedu zadejte parametr -h nebo --help.\n");
          return (1);
        }
      break;
      
      default : printf("Spatny pocet parametru. Pro napovedu zadejte parametr -h nebo --help.\n"); return (1);
	  
	} /* EO dekodovani vstupnich parametru */


  pipe(fdSC);
  
  pidS = fork();
  if (pidS > 0) {  
  /* ******* proces C ********/
  
    close(fdSC[1]);
  
    while (count < c) 
      if (read(fdSC[0], &rnd, sizeof(rnd)) != 0)  {
        printf("%d.prvek - hodn: %d\n",++count,rnd);  
        fflush(stdout);
      }
      else sleep(1);
  }
  else {
  
    close(fdSC[0]);
  
    pipe(fdPS);
  
    pidP = fork();
    if (pidP > 0) {
    /* ******proces S **********/
    
      close(fdPS[1]);
      
      while (count < c ) {  
        for (i = 0; (i < u) && (count < c); i++)  /* u setrideni za jednotku casu */
          if (read(fdPS[0], &rnd, sizeof(rnd)) != 0) {/* ctu z P */
            count++;
            if (AddToQ(rnd)) printf("Nedostatek pameti pro razeni\n"); 
          }

        while ( RemFromQ(&rnd) == 0 ) /* serazene poslu do C */
           write( fdSC[1], &rnd, sizeof(rnd) ); /* posilam do C */ 
          
        fflush( (void*) (fdSC + sizeof(int)) );    
    
        sleep(1);
      }
                  
    }
    else {
    /* *****proces P ***********/
      close(fdPS[0]);
      
      
    for (i=0; i < c; i++) {  
      rnd = rand() % MAX;                   /* generuju */   
      write( fdPS[1], &rnd, sizeof(rnd) );  /* posilam do S */
      count++;
      fflush( (void*) (fdPS + sizeof(int)) );    
      if (((count) % v) == 0) sleep (1); /* v generovanych cisel za jednotku casu */ 
    }
    
    }  
  }
}
