/************************************************************************ 
 *  main.c
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/


#include <stdio.h>
#include <stdlib.h>

#include "zasobnik.h"
#include "sachovnice.h"
#include "buffer.h"

#include "mpi.h"


#define CITAC_MAX                100

#define CERNA                    0
#define BILA                     1

#define MSG_INIT                 1000
#define MSG_FINISH               1001
#define MSG_VELIKOST_SACHOVNICE  1002
#define MSG_SACHOVNICE           1003
#define MSG_BEST_RESULT          1004
#define MSG_WORK_REQUEST         1005
#define MSG_WORK                 1006
#define MSG_NO_WORK              1007
#define MSG_TOKEN                1008


#define ENABLE_OUTPUT



int main(int argc, char *argv[])
{
  
  int k, q = 0, i;
  char *soubor;

  Zasobnik zasobnik;             /* zasobnik */
  Sachovnice sachovnice;         /* hraci pole */
  Sachovnice sachovnice_original; /* puvodni sachovnice (nactena ze souboru) */
  Tah tah, novyTah;
  int x, y, noveTahy;
  int dolni_mez, horni_mez;        /* dolni a horni mez reseni */
  Vysledek vysledek;             /* zatim nejlepsi vysledek */

  int moje_cislo = 0, pocet_kompu = 1;
  Buffer buffer;                 /* buffer pro prijimani a odesilani zprav */
  int citac = 0;
  int flag = 0;
  int do_loop = 1;

  int darce = 0;
  int pocet_zadosti = 0;
  int zazadano = 0;
  int idle = 0;

  MPI_Status mpi_status;

  /* mereni casu */
  double startTime = 0;
  double endTime = 0;

  /* ADUV */
  int mam_peska = 0;
  int barva = BILA;
  int prijata_barva;
  char* barvy[2] = {"black", "white"};



  MPI_Init( &argc, &argv );
  MPI_Comm_rank(MPI_COMM_WORLD, &moje_cislo);
  MPI_Comm_size(MPI_COMM_WORLD, &pocet_kompu);

  printf("[%d]: Nodes count %d\n", moje_cislo, pocet_kompu);


  if (moje_cislo == 0) {
      
	  /* Pokud jsem master: 
	     (1) nactu vstupni data ze souboru do sachovnice
	     (2) odeslu ostatnim zpravu o velikosti sachovnice
		 (3) odeslu ostatnim sachovnici
	  */

	  if (argc < 4) {
		 printf("Othello - parallel solution: error in parameters\n");           
		 printf("Use: othello k q input.txt\n");           
		 printf("k >= 5, chessboard size\n");      
		 printf("q, number of white mans\n");
         
		 /* Pokud nebyly zadane spravne parametry, ukoncim vypocet. */
		 for(i = 1; i < pocet_kompu; i++) {
           MPI_Send(&i, 1, MPI_INT, i, MSG_FINISH, MPI_COMM_WORLD);
		 }
		 MPI_Barrier(MPI_COMM_WORLD);
         MPI_Finalize();
		 return 1;
	  }
	  k = atoi(argv[argc - 3]);
	  q = atoi(argv[argc - 2]);
	  soubor = argv[argc - 1];
	  /*for(i = 0; i < argc; i++) {
		printf("%s\n", argv[i]);
	  }*/
	  	  
	  sachovniceInit(&sachovnice_original, k);
	  
	  if (sachovniceNacti(&sachovnice_original, soubor, k, q)) {
		/* Pokud nebyly zadane spravne parametry, ukoncim vypocet. */
		for(i = 1; i < pocet_kompu; i++) {
          MPI_Send(&i, 1, MPI_INT, i, MSG_FINISH, MPI_COMM_WORLD);
		}
		MPI_Barrier(MPI_COMM_WORLD);
		MPI_Finalize();
		sachovniceDeinit(&sachovnice_original);
		return 1;
	  }

	  /* odeslani velikosti sachovnice */
	  for(i = 1; i < pocet_kompu; i++) {
		printf("[%d]: Sending chessboard size (%d) to %d.\n", moje_cislo, sachovnice_original.strana, i);
	    MPI_Send(&(sachovnice_original.strana), 1, MPI_INT, i, MSG_VELIKOST_SACHOVNICE, MPI_COMM_WORLD);
	  }

	  /* odeslani sachovnice pres buffer */
      bufferInit(&buffer, sachovnice_original.strana * sachovnice_original.strana * sizeof(int));
      sachovnicePack(&sachovnice_original, &buffer);
      for(i = 1; i < pocet_kompu; i++) {
		printf("[%d]: Sending chessboard to %d.\n", moje_cislo, i);
	    MPI_Send(buffer.buffer, buffer.velikost, MPI_PACKED, i, MSG_SACHOVNICE, MPI_COMM_WORLD);
	  }

	  darce = 1;
	  MPI_Barrier(MPI_COMM_WORLD);
	  startTime = MPI_Wtime();

  } else {

    /* Pokud jsem slave
	   (1) cekam na zpravu o velikosti sachovnice a podle prijate hodnoty vytvorim buffer
	   (2) prijmu sachovnici
	*/

    /* (1) */
	int velikostSachovnice = 0;

	printf("[%d]: Waiting for chessboard size...\n", moje_cislo);

	MPI_Recv(&velikostSachovnice, 1, MPI_INT, MPI_ANY_SOURCE, MPI_ANY_TAG, MPI_COMM_WORLD, &mpi_status);
	if (mpi_status.MPI_TAG == MSG_FINISH) {
	  MPI_Barrier(MPI_COMM_WORLD);
	  MPI_Finalize();
      return 1;
	}

	printf("[%d]: Chessboard size received from %d. It is %d.\n", moje_cislo, mpi_status.MPI_SOURCE, velikostSachovnice);
	bufferInit(&buffer, velikostSachovnice * velikostSachovnice * sizeof(int));

	/* (2) */
	printf("[%d]: Waiting for chessboard...\n", moje_cislo);
	MPI_Recv(buffer.buffer, buffer.kapacita, MPI_PACKED, MPI_ANY_SOURCE, MSG_SACHOVNICE, MPI_COMM_WORLD, &mpi_status);
	printf("[%d]: Chessboard received from %d.\n", moje_cislo, mpi_status.MPI_SOURCE);
    sachovniceInit(&sachovnice_original, velikostSachovnice);
	sachovniceUnpack(&sachovnice_original, &buffer);
	/*sachovniceVypis(&sachovnice_original, 0);
	printf("\n");*/
	MPI_Barrier(MPI_COMM_WORLD);
  }



  /* vypocet horni meze */
  horni_mez = sachovnicePocetVolnychSousedu(&sachovnice_original);
  if ((2 * q) < horni_mez) {
    horni_mez = 2 * q;
  }
  /* vypocet dolni meze */
  dolni_mez = sachovnicePocetKomponent(&sachovnice_original) + 1;

  /* nastaveni nejlepsiho zatim nalezeneho reseni */
  vysledekInit(&vysledek);
  vysledek.pocetTahu = horni_mez + 1;

  /* vypocet maximalni delky bufferu */
  x = sachovnice_original.strana * sachovnice_original.strana * sizeof(int); /* velikost sachovnice */
  y = sizeof(int) + (2 + horni_mez + MAX_POSLANYCH_TAHU) * (3 * sizeof(int)); /*  x + y + zahrany == 3  */
  bufferInit(&buffer, (x > y ? x : y));

#ifdef ENABLE_OUTPUT
  if (moje_cislo == 0) {
	  printf("[%d]: The lowest bound is %d, the upper is %d\n", moje_cislo, dolni_mez, horni_mez);
	  printf("[%d]: The size of buffer is %d bytes.\n", moje_cislo, buffer.kapacita);
  }
#endif

  zasobnikInit(&zasobnik);
  if (moje_cislo == 0) {
    tahInit(&tah, 0, 0, 0);
	zasobnikVloz(&zasobnik, tah); /* vlozim na zasobnik startovni tah, ktery nic nedela */
  }

  sachovnice.strana = 0;
  sachovniceKopiruj(&sachovnice_original, &sachovnice); /* vytvorim si kopii sachovnice pro dalsi praci */








  while (do_loop) {
    
	if (zasobnik.velikost > 0) {

      tah = zasobnikVyjmi(&zasobnik);
    
	  if (tah.odeslany) {
        
	    tahDeinit(&tah);
        
	  } else if (tah.zahrany) {
        
        sachovniceVratTah(&sachovnice, &tah);
        tahDeinit(&tah);
        
      } else {
        
        if (tah.cisloTahu != 0) {
          sachovniceUmistiKamen(&sachovnice, &tah);
          zasobnikVloz(&zasobnik, tah); /* tah je v tuto chvili uz zahrany */
        }
      
        if (sachovniceZadnyBily(&sachovnice)) { /* koncovy stav */
                                            
          /* pokud je reseni na nejmene tahu, ulozit ho a odeslat vsem ostatnim */
          if (tah.cisloTahu < vysledek.pocetTahu) {
            vysledekDeinit(&vysledek);
            zasobnikUlozVysledek(&zasobnik, &vysledek);
#ifdef ENABLE_OUTPUT
			printf("[%d]: New best solution found: %d\n", moje_cislo, vysledek.pocetTahu);
#endif
			vysledekPack(&vysledek, &buffer);
			/* odeslat vysledek vsem ostatnim */
			for(i = 0; i < pocet_kompu; i++) {
			  if (i != moje_cislo) {
#ifdef ENABLE_OUTPUT
				printf("[%d]: Sending new best solution (%d) to %d.\n", moje_cislo, vysledek.pocetTahu, i);
#endif
			    MPI_Send(buffer.buffer, buffer.velikost, MPI_PACKED, i, MSG_BEST_RESULT, MPI_COMM_WORLD);
			  }
			}
          }
        
          /* pokud je to absolutne nejlepsi reseni, tak odeslat finish */
          if (vysledek.pocetTahu <= dolni_mez) {
#ifdef ENABLE_OUTPUT
			printf("[%d]: Absolutely best solution found: %d\n", moje_cislo, vysledek.pocetTahu);
#endif
			for(i = 0; i < pocet_kompu; i++) {
			  if (i != moje_cislo) {
#ifdef ENABLE_OUTPUT
                printf("[%d]: Sending finish to %d.\n", moje_cislo, i);
#endif
			    MPI_Send(&i, 1, MPI_INT, i, MSG_FINISH, MPI_COMM_WORLD);
			  }
			}
            break;
          }
        
        } else if (tah.cisloTahu < vysledek.pocetTahu) { /* nejedna se o koncovy stav */
          /* Pokud by bylo dalsi zanoreni vetsi nez je nejlepsi dosud nalezeny pocet tahu, nema smysl dal expandovat. */

          /* expanze dalsich tahu */
          noveTahy = 0;
          for(x = 0; x < sachovnice.strana; x++) {
            for(y = 0; y < sachovnice.strana; y++) {
              if (sachovnice.pole[x][y] == 0 && sachovniceJeVedleBilyKamen(&sachovnice, x, y)) {
                noveTahy++;
                tahInit(&novyTah, x, y, tah.cisloTahu + 1);
                novyTah.pocetObarveni = sachovniceHodnota(&sachovnice, x, y);
                zasobnikVloz(&zasobnik, novyTah);
              }
            } 
          }
          zasobnikSeradTahyPodlePoctuObarveni(&zasobnik, noveTahy);
        }

	  } /* end of nezahrany */

	} else if (pocet_kompu > 1) { 

	  /* stack is empty => hledej praci */
      
	  if (!idle && !zazadano) {
#ifdef ENABLE_OUTPUT
	    printf("[%d]: Sending work request to %d.\n", moje_cislo, darce);
#endif
	    MPI_Send(&i, 1, MPI_INT, darce, MSG_WORK_REQUEST, MPI_COMM_WORLD); /* odeslu zadost */
		zazadano = 1;
	  }

	} else {
	  /* zasobnik je prazdny a zaroven jsem sam => konec */
	  do_loop = 0;
	}


	if (citac++ < CITAC_MAX) {
	  continue;
	}
	citac = 0;

    i = MPI_Iprobe(MPI_ANY_SOURCE, MPI_ANY_TAG, MPI_COMM_WORLD, &flag, &mpi_status);
	if (i == MPI_SUCCESS && flag) {
      switch(mpi_status.MPI_TAG) {

        case MSG_WORK_REQUEST:
		  MPI_Recv(&i, 1, MPI_INT, mpi_status.MPI_SOURCE, MSG_WORK_REQUEST, MPI_COMM_WORLD, &mpi_status);
#ifdef ENABLE_OUTPUT
		  printf("[%d]: Work request received from %d.\n", moje_cislo, mpi_status.MPI_SOURCE);
#endif
		  i = zasobnikRozdel(&zasobnik, &buffer, horni_mez - 2);
		  if (i > 0) {
			/* zasobnik se podarilo rozdelit */
#ifdef ENABLE_OUTPUT
			printf("[%d]: Sending stack to %d. The stack size is %d (%d bytes).\n", moje_cislo, mpi_status.MPI_SOURCE, i, buffer.velikost);
#endif
			MPI_Send(buffer.buffer, buffer.velikost, MPI_PACKED, mpi_status.MPI_SOURCE, MSG_WORK, MPI_COMM_WORLD);
			if (mpi_status.MPI_SOURCE < moje_cislo) {
			  barva = CERNA;
			}
		  } else {
			/* zasobnik se nepodarilo rozdelit => neni prace */
#ifdef ENABLE_OUTPUT
			printf("[%d]: Sending no work to %d.\n", moje_cislo, mpi_status.MPI_SOURCE);
#endif
		    MPI_Send(&i, 1, MPI_INT, mpi_status.MPI_SOURCE, MSG_NO_WORK, MPI_COMM_WORLD);
		  }
          break;

		case MSG_WORK:
#ifdef ENABLE_OUTPUT
		  if (zasobnik.velikost > 0) {
		    printf("[%d]: Work received when stack has nonzero size!", moje_cislo);
		  }
#endif
		  zazadano = 0;
		  pocet_zadosti = 0;
          darce = (darce + 1) % pocet_kompu;
		  if (darce == moje_cislo) {
			darce = (darce + 1) % pocet_kompu;
		  }

		  sachovniceKopiruj(&sachovnice_original, &sachovnice);
#ifdef ENABLE_OUTPUT
		  printf("[%d]: Work received from %d.\n", moje_cislo, mpi_status.MPI_SOURCE, zasobnik.velikost);
#endif
		  MPI_Recv(buffer.buffer, buffer.kapacita, MPI_PACKED, mpi_status.MPI_SOURCE, MSG_WORK, MPI_COMM_WORLD, &mpi_status);
#ifdef ENABLE_OUTPUT
		  printf("[%d]: The message size is %d bytes.\n", moje_cislo, mpi_status.count);
#endif
          zasobnikPrijmi(&zasobnik, &sachovnice, &buffer);
#ifdef ENABLE_OUTPUT
		  printf("[%d]: The stack size is %d.\n", moje_cislo, zasobnik.velikost);
#endif
		  break;

		case MSG_NO_WORK:
		  MPI_Recv(buffer.buffer, buffer.kapacita, MPI_PACKED, mpi_status.MPI_SOURCE, MSG_NO_WORK, MPI_COMM_WORLD, &mpi_status);
#ifdef ENABLE_OUTPUT
		  printf("[%d]: No work received from %d.\n", moje_cislo, mpi_status.MPI_SOURCE);
#endif
		  zazadano = 0;
		  pocet_zadosti++;
		  if (pocet_zadosti >= pocet_kompu) {
#ifdef ENABLE_OUTPUT
			printf("[%d]: Switching to idle state...\n", moje_cislo);
#endif
		    idle = 1;

            /* Po prepnuti do stavu idle musim provest nejake operace. */
			if (moje_cislo == 0) {
			  barva = BILA;
			  MPI_Send(&barva, 1, MPI_INT, (moje_cislo + 1) % pocet_kompu, MSG_TOKEN, MPI_COMM_WORLD);
#ifdef ENABLE_OUTPUT
			  printf("[%d]: Sending %s token to %d.\n", moje_cislo, barvy[barva], (moje_cislo + 1) % pocet_kompu);
#endif
			} else {
			  if (mam_peska) {
			    MPI_Send(&barva, 1, MPI_INT, (moje_cislo + 1) % pocet_kompu, MSG_TOKEN, MPI_COMM_WORLD);
#ifdef ENABLE_OUTPUT
				printf("[%d]: Sending %s token to %d.\n", moje_cislo, barvy[barva], (moje_cislo + 1) % pocet_kompu);
#endif
				barva = BILA;
				mam_peska = 0;
			  }
			}

		  } else {
		    darce = (darce + 1) % pocet_kompu;
		    if (darce == moje_cislo) {
			  darce = (darce + 1) % pocet_kompu;
		    }
		  }
	      break;

		case MSG_BEST_RESULT:
          MPI_Recv(buffer.buffer, buffer.kapacita, MPI_PACKED, mpi_status.MPI_SOURCE, MSG_BEST_RESULT, MPI_COMM_WORLD, &mpi_status);
		  vysledekUnpack(&vysledek, &buffer);
		  
		  if (vysledek.pocetTahu <= dolni_mez) {
#ifdef ENABLE_OUTPUT
   		    printf("[%d]: Absolutely best solution received from %d.\n", moje_cislo, mpi_status.MPI_SOURCE);
#endif
            do_loop = 0;
		  } else {
#ifdef ENABLE_OUTPUT
			printf("[%d]: New best result received from %d. The new best result is %d.\n", moje_cislo, mpi_status.MPI_SOURCE, vysledek.pocetTahu);
#endif
		  }
		  break;

        case MSG_TOKEN:
		  MPI_Recv(&prijata_barva, 1, MPI_INT, mpi_status.MPI_SOURCE, MSG_TOKEN, MPI_COMM_WORLD, &mpi_status);
#ifdef ENABLE_OUTPUT
		  printf("[%d]: Token (%s) received from %d.\n", moje_cislo, barvy[prijata_barva], mpi_status.MPI_SOURCE);
#endif

		  if (moje_cislo == 0) {

			if (prijata_barva == BILA) {
              for(i = 0; i < pocet_kompu; i++) {
			    if (i != moje_cislo) {
#ifdef ENABLE_OUTPUT
                  printf("[%d]: Sending finish to %d.\n", moje_cislo, i);
#endif
			      MPI_Send(&i, 1, MPI_INT, i, MSG_FINISH, MPI_COMM_WORLD);
			    }
			  }
			  do_loop = 0;
			} else {
			  barva = BILA;
              MPI_Send(&barva, 1, MPI_INT, (moje_cislo + 1) % pocet_kompu, MSG_TOKEN, MPI_COMM_WORLD);
#ifdef ENABLE_OUTPUT
			  printf("[%d]: Sending %s token to %d.\n", moje_cislo, barvy[barva], (moje_cislo + 1) % pocet_kompu);
#endif
			}

		  } else {

			  if (idle == 0) {
                mam_peska = 1;
				if (barva == BILA) {
				  barva = prijata_barva;
				}
			  } else {
				if (barva == BILA) {
				  barva = prijata_barva;
				}
                MPI_Send(&barva, 1, MPI_INT, (moje_cislo + 1) % pocet_kompu, MSG_TOKEN, MPI_COMM_WORLD);
#ifdef ENABLE_OUTPUT
				printf("[%d]: Sending %s token to %d.\n", moje_cislo, barvy[barva], (moje_cislo + 1) % pocet_kompu);
#endif
				barva = BILA;
			  }

		  }
          break;

        case MSG_FINISH:
		  MPI_Recv(buffer.buffer, buffer.kapacita, MPI_PACKED, mpi_status.MPI_SOURCE, MSG_FINISH, MPI_COMM_WORLD, &mpi_status);
          do_loop = 0;
          break;

        default: 
		  MPI_Recv(buffer.buffer, buffer.kapacita, MPI_PACKED, mpi_status.MPI_SOURCE, MPI_ANY_TAG, MPI_COMM_WORLD, &mpi_status);
#ifdef ENABLE_OUTPUT
		  printf("[%d]: Unknow message received. The tag is %d.\n", moje_cislo, mpi_status.MPI_TAG);
#endif
		  break;
      }
	} /* end of flag test */
        
  } /* end of while(do_loop) */
  
#ifdef ENABLE_OUTPUT
  printf("[%d]: End of loop...waiting for barrier\n", moje_cislo);
#endif
  MPI_Barrier(MPI_COMM_WORLD);
  endTime = MPI_Wtime();
  MPI_Finalize();
  printf("[%d]: Barrier reached.\n", moje_cislo);
  

  bufferDeinit(&buffer);
  zasobnikDeinit(&zasobnik);
  sachovniceDeinit(&sachovnice);
  

  if (moje_cislo == 0) {
	if (vysledek.pocetTahu == horni_mez + 1) {
	  printf("\nResult not found.\n\n");
	} else {
      vysledekVypis(&vysledek);
	  sachovniceVypis(&sachovnice_original, &vysledek);
	}
	printf("Time: %f\n\n", endTime - startTime);
	getchar();
  }
  
  sachovniceDeinit(&sachovnice_original);
  vysledekDeinit(&vysledek);
  
  return 0;
}
