/************************************************************************ 
 *  zasobnik.c
 *  zasobnik tahu, implementace
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifdef WIN32
#include <stdlib.h>
#include <memory.h>
#endif

#include "mpi.h"


#include "zasobnik.h"

void zasobnikInit(Zasobnik* zasobnik) {
  if (zasobnik) {
    zasobnik->velikost = 0;
    zasobnik->kapacita = 8;
    zasobnik->prvky = (Tah*)malloc(sizeof(Tah) * 8);
  }
}

void zasobnikDeinit(Zasobnik* zasobnik) {
  if (zasobnik && zasobnik->kapacita > 0) {
    int i;
    for(i = 0; i < zasobnik->velikost; i++) {
      tahDeinit(&(zasobnik->prvky[i]));
    }
    zasobnik->velikost = 0;
    zasobnik->kapacita = 0;
    if (zasobnik->prvky) {
      free((void*)zasobnik->prvky);
      zasobnik->prvky = 0;
    }
  }
}

void zasobnikVloz(Zasobnik* zasobnik, Tah prvek) {
  if (zasobnik) {
    if (zasobnik->velikost >= zasobnik->kapacita) {
      zasobnik->kapacita = zasobnik->kapacita * 2;
      zasobnik->prvky = (Tah*)realloc((void*)zasobnik->prvky, sizeof(Tah) * zasobnik->kapacita);             
    }
    zasobnik->velikost = zasobnik->velikost + 1;
    zasobnik->prvky[zasobnik->velikost - 1] = prvek;
  }
}

Tah zasobnikVyjmi(Zasobnik* zasobnik) {
  Tah result;
  if (zasobnik && zasobnik->velikost > 0) {
    zasobnik->velikost = zasobnik->velikost - 1;
    return zasobnik->prvky[zasobnik->velikost];
  } else {
    tahInit(&result, 0, 0, 0);
	return result;
  }
}


/*void zasobnikQSort(Zasobnik* zasobnik, int l, int r) {
  int i, j, x;
  Tah w;
  i = l; j = r;
  x = zasobnik->prvky[(l+r)/2].pocetObarveni;
  do {
    while (zasobnik->prvky[i].pocetObarveni < x) i++;
    while (zasobnik->prvky[j].pocetObarveni > x) j--;
    if (i <= j) {
      w = zasobnik->prvky[i];
      zasobnik->prvky[i] = zasobnik->prvky[j];
      zasobnik->prvky[j] = w;
      i++; j--;
    }
  } while (i >= j);
  
  if (l < j) zasobnikQSort(zasobnik, l, j);
  if (i < r) zasobnikQSort(zasobnik, i, r);  
}*/

void zasobnikQSort(Zasobnik* zasobnik, int left, int right) {
  int l_hold, r_hold, x;
  Tah pivot;

  l_hold = left;
  r_hold = right;

  pivot = zasobnik->prvky[left];
  while (left < right)
  {
	while ((zasobnik->prvky[right].pocetObarveni >= pivot.pocetObarveni) && (left < right)) right--;
    if (left != right)
    {
      zasobnik->prvky[left] = zasobnik->prvky[right];
      left++;
    }
	while ((zasobnik->prvky[left].pocetObarveni <= pivot.pocetObarveni) && (left < right)) left++;
    if (left != right)
    {
      zasobnik->prvky[right] = zasobnik->prvky[left];
      right--;
    }
 }
 zasobnik->prvky[left] = pivot;
 x = left;
 left = l_hold;
 right = r_hold;
 if (left < x)
   zasobnikQSort(zasobnik, left, x - 1);
 if (right > x)
   zasobnikQSort(zasobnik, x + 1, right);
}


void zasobnikSeradTahyPodlePoctuObarveni(Zasobnik* zasobnik, int count) {
  if (zasobnik) {
    int i;
    if (zasobnik->velikost < count) count = zasobnik->velikost;
    zasobnikQSort(zasobnik, zasobnik->velikost - count, zasobnik->velikost - 1);
    for(i = zasobnik->velikost - count; i < zasobnik->velikost; i++) {
      zasobnik->prvky[i].pocetObarveni = 0;
    }
  }
}


void zasobnikUlozVysledek(Zasobnik* zasobnik, Vysledek* vysledek) {
  if (zasobnik && vysledek) {
    int i;
    for(i = 0; i < zasobnik->velikost; i++) {
      if (zasobnik->prvky[i].zahrany) {
        vysledekPridejPozici(vysledek, zasobnik->prvky[i].pozice);
      }
    }
  }
}


int zasobnikRozdel(Zasobnik* zasobnik, Buffer* buffer, int rez) {
  if (zasobnik && buffer) {
    int i = 0, uroven, skutecny_pocet = 0, zahrane = 0;
	
	buffer->velikost = 0;

	/* vyhradim si na zacatku bufferu misto na pocet tahu */
	MPI_Pack(&skutecny_pocet, 1, MPI_INT, buffer->buffer, buffer->kapacita, &(buffer->velikost), MPI_COMM_WORLD);

	/* Hledam prvni polozku v zasobniku, ktera neni odeslana ani zahrana, lze ji tedy odeslat.
	   Tato polozka ale nesmi byt pod reznou hladinou.
	   Pri prohledavani si ukladam zahrane tahy. */
	while(i < zasobnik->velikost && zasobnik->prvky[i].cisloTahu <= rez) {
	  if (zasobnik->prvky[i].zahrany) {
	    
		zahrane++;
		pozicePack(&(zasobnik->prvky[i].pozice), buffer);
        MPI_Pack(&(zasobnik->prvky[i].zahrany), 1, MPI_INT, buffer->buffer, buffer->kapacita, &(buffer->velikost), MPI_COMM_WORLD);
        i++;

	  } else if (!(zasobnik->prvky[i].zahrany) && !(zasobnik->prvky[i].odeslany)) {

	    /* Nasel jsem jeden tah, ktery mohu odeslat nekomu jinemu. */
	    int start = i, pocet = 0;
		uroven = zasobnik->prvky[start].cisloTahu;

		/* Nejprve spocitam pocet tahu, ktere muzu odeslat. */
		for(i = start; i < zasobnik->velikost; i++) {
		  if (zasobnik->prvky[i].cisloTahu > uroven) { /* nechci vyjet z urovne, na ktere byl prvni nalezeny tah */
		    break;
		  } else if (!(zasobnik->prvky[i].zahrany) && !(zasobnik->prvky[i].odeslany)) {
			pocet++;
		  }
		}

		/* Nyni si zapisu tahy do bufferu. */
		for(i = start; i < zasobnik->velikost; i++) {
		  if (zasobnik->prvky[i].cisloTahu > uroven) { /* nechci vyjet z urovne, na ktere byl prvni nalezeny tah */
		    break;
		  } else if (!(zasobnik->prvky[i].zahrany) && !(zasobnik->prvky[i].odeslany)) {
			skutecny_pocet++;
			zasobnik->prvky[i].odeslany = 1;
			pozicePack(&(zasobnik->prvky[i].pozice), buffer);
            MPI_Pack(&(zasobnik->prvky[i].zahrany), 1, MPI_INT, buffer->buffer, buffer->kapacita, &(buffer->velikost), MPI_COMM_WORLD);
			if (skutecny_pocet > (pocet / 2) || (skutecny_pocet >= MAX_POSLANYCH_TAHU)) {
			  break;
			}
		  }
		}

		/* Na zacatek bufferu si zapisu, kolik jsem do nej ulozil tahu. */
		pocet = 0; /* bude ted udavat offset */
		skutecny_pocet += zahrane;
	    MPI_Pack(&skutecny_pocet, 1, MPI_INT, buffer->buffer, buffer->kapacita, &pocet, MPI_COMM_WORLD);
		return skutecny_pocet;

	  } else {
	    i++;
	  }
	}
  }
  return 0;
}


void zasobnikPrijmi(Zasobnik* zasobnik, Sachovnice* sachovnice, Buffer* buffer) {
  if (zasobnik && buffer) {
    int i, count = 0, uroven = 1, zahrany = 0;
	zasobnikDeinit(zasobnik);
	zasobnikInit(zasobnik);
	/* nactu pocet polozek v prijatem zasobniku */
	buffer->pozice = 0;
	MPI_Unpack(buffer->buffer, buffer->kapacita, &(buffer->pozice), &count, 1, MPI_INT, MPI_COMM_WORLD);
	for(i = 0; i < count; i++) {
	  Tah tah;
	  MPI_Unpack(buffer->buffer, buffer->kapacita, &(buffer->pozice), &(tah.pozice.x), 1, MPI_INT, MPI_COMM_WORLD);
	  MPI_Unpack(buffer->buffer, buffer->kapacita, &(buffer->pozice), &(tah.pozice.y), 1, MPI_INT, MPI_COMM_WORLD);
	  MPI_Unpack(buffer->buffer, buffer->kapacita, &(buffer->pozice), &zahrany,        1, MPI_INT, MPI_COMM_WORLD);
	  tahInit(&tah, tah.pozice.x, tah.pozice.y, uroven);
	  if (zahrany) {
	    sachovniceUmistiKamen(sachovnice, &tah);
		uroven++;
	  }
	  zasobnikVloz(zasobnik, tah);
	}
  }
}
