/************************************************************************ 
 *  main.c
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/


#include <stdio.h>
#include <stdlib.h>

#include "zasobnik.h"
#include "sachovnice.h"

int main(int argc, char *argv[])
{
  
  int k,q;
  char *soubor;
  
  Zasobnik zasobnik;
  Sachovnice sachovnice;
  Tah tah, novyTah;
  int x, y, noveTahy, dolniMez;
  Vysledek vysledek;

  if (argc != 4) {
     printf("Othello sekvencni reseni: CHYBA V ZADANI\n");           
     printf("Pouziti: othello k q vstup.txt\n");           
     printf("k = cele cislo, k >= 5, reprezentujici delku strany sachovnice\n");
     printf("q = cele cislo reprezentujici pocet rozmistenych bilych kamenu\n");
     return 1;
  }
  k = atoi(argv[1]);
  q = atoi(argv[2]);
  soubor = argv[3];
  
  zasobnikInit(&zasobnik);
  sachovniceInit(&sachovnice, k);
  
  if (sachovniceNacti(&sachovnice, soubor, k, q)) {
    return 1;
  }
  
  /* vlozim na zasobnik startovni tah, ktery nic nedela */
  tahInit(&tah, 0, 0, 0);
  zasobnikVloz(&zasobnik, tah);
  vysledekInit(&vysledek);
  
  /* nastavim nejhorsi mozne reseni */
  vysledek.pocetTahu = sachovnicePocetVolnychSousedu(&sachovnice);
  if ((2 * q) < vysledek.pocetTahu) {
    vysledek.pocetTahu = 2 * q;
  }
  vysledek.pocetTahu++;
  
  dolniMez = sachovnicePocetKomponent(&sachovnice) + 1;

  while (zasobnik.velikost > 0) {
        
    tah = zasobnikVyjmi(&zasobnik);
    
    if (tah.zahrany) {
                     
      sachovniceVratTah(&sachovnice, &tah);
      tahDeinit(&tah);
      
    } else {
           
      if (tah.cisloTahu != 0) {
        sachovniceUmistiKamen(&sachovnice, &tah);
        zasobnikVloz(&zasobnik, tah); /* tah je v tuto chvili uz zahrany */
      }
      
      if (sachovniceZadnyBily(&sachovnice)) {
                                            
        /* pokud je reseni na nejmene tahu, ulozit ho */
        if (tah.cisloTahu < vysledek.pocetTahu) {
          vysledekDeinit(&vysledek);
          zasobnikUlozVysledek(&zasobnik, &vysledek);
        }
        
        /* pokud je to absolutne nejlepsi reseni, tak skoncit */
        if (vysledek.pocetTahu <= dolniMez) {
          break;
        }
        
      } else {
        
        /* Pokud by bylo dalsi zanoreni vetsi nez je nejlepsi dosud nalezeny pocet tahu, nema smysl dal expandovat. */
        if (tah.cisloTahu >= vysledek.pocetTahu) {
          continue;
        }
                
        
        /* expanze dalsich tahu */
        noveTahy = 0;
        for(x = 0; x < sachovnice.strana; x++) {
          for(y = 0; y < sachovnice.strana; y++) {
            if (sachovnice.pole[x][y] == 0 && sachovniceJeVedleBilyKamen(&sachovnice, x, y)) {
              noveTahy++;
              tahInit(&novyTah, x, y, tah.cisloTahu + 1);
              novyTah.pocetObarveni = sachovniceHodnota(&sachovnice, x, y);
              zasobnikVloz(&zasobnik, novyTah);
            }
          } 
        }
        zasobnikSeradTahyPodlePoctuObarveni(&zasobnik, noveTahy);
      }
    }
        
  }
  
  zasobnikDeinit(&zasobnik);
  sachovniceDeinit(&sachovnice);
  

  vysledekVypis(&vysledek);

  sachovniceInit(&sachovnice, k);
  if (sachovniceNacti(&sachovnice, soubor, k, q)) {
    return 1;
  }
  
  sachovniceVypis(&sachovnice, &vysledek);

  getchar();
  
  vysledekDeinit(&vysledek);
  
  return 0;
}
