/************************************************************************ 
 *  tah.c
 *  tah pro sekvencni reseni, implementace ...
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifdef WIN32
#include <stdlib.h>
#include <memory.h>
#endif

#include "tah.h"

void tahInit(Tah* tah, int x, int y, int cisloTahu) {
  if (tah) {
    tah->pozice.x = x;
    tah->pozice.y = y;
    tah->zahrany = 0;
    tah->cisloTahu = cisloTahu;
    tah->pocetObarveni = 0;
    tah->obarveni = 0;
  }     
}

void tahDeinit(Tah* tah) {
  if (tah) {
    tah->pocetObarveni = 0;
    if (tah->obarveni) {
      free((void*)tah->obarveni);
    }         
  }
}

void tahPridejObarveni(Tah* tah, int x, int y) {
  if (tah) {
    if (tah->obarveni) {
      tah->obarveni = (Pozice*)realloc((void*)tah->obarveni, sizeof(Pozice) * (tah->pocetObarveni + 1));
    } else {
      tah->obarveni = (Pozice*)malloc(sizeof(Pozice) * 1);
    }
    tah->obarveni[tah->pocetObarveni].x = x;
    tah->obarveni[tah->pocetObarveni].y = y;
    tah->pocetObarveni = tah->pocetObarveni + 1;
  }     
}
