/************************************************************************ 
 *  zasobnik.c
 *  zasobnik pro sekvencni reseni, implementace ...
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifdef WIN32
#include <stdlib.h>
#include <memory.h>
#endif

#include "zasobnik.h"

void zasobnikInit(Zasobnik* zasobnik) {
  if (zasobnik) {
    zasobnik->velikost = 0;
    zasobnik->kapacita = 8;
    zasobnik->prvky = (Tah*)malloc(sizeof(Tah) * 8);
  }
}

void zasobnikDeinit(Zasobnik* zasobnik) {
  if (zasobnik && zasobnik->kapacita > 0) {
    int i;
    for(i = 0; i < zasobnik->velikost; i++) {
      tahDeinit(&(zasobnik->prvky[i]));
    }
    zasobnik->velikost = 0;
    zasobnik->kapacita = 0;
    if (zasobnik->prvky) {
      free((void*)zasobnik->prvky);
      zasobnik->prvky = 0;
    }
  }
}

void zasobnikVloz(Zasobnik* zasobnik, Tah prvek) {
  if (zasobnik) {
    if (zasobnik->velikost >= zasobnik->kapacita) {
      zasobnik->kapacita = zasobnik->kapacita * 2;
      zasobnik->prvky = (Tah*)realloc((void*)zasobnik->prvky, sizeof(Tah) * zasobnik->kapacita);             
    }
    zasobnik->velikost = zasobnik->velikost + 1;
    zasobnik->prvky[zasobnik->velikost - 1] = prvek;
  }
}

Tah zasobnikVyjmi(Zasobnik* zasobnik) {
  Tah result;
  if (zasobnik && zasobnik->velikost > 0) {
    zasobnik->velikost = zasobnik->velikost - 1;
    return zasobnik->prvky[zasobnik->velikost];
  } else {
    tahInit(&result, 0, 0, 0);
	return result;
  }
}


/*void zasobnikQSort(Zasobnik* zasobnik, int l, int r) {
  int i, j, x;
  Tah w;
  i = l; j = r;
  x = zasobnik->prvky[(l+r)/2].pocetObarveni;
  do {
    while (zasobnik->prvky[i].pocetObarveni < x) i++;
    while (zasobnik->prvky[j].pocetObarveni > x) j--;
    if (i <= j) {
      w = zasobnik->prvky[i];
      zasobnik->prvky[i] = zasobnik->prvky[j];
      zasobnik->prvky[j] = w;
      i++; j--;
    }
  } while (i >= j);
  
  if (l < j) zasobnikQSort(zasobnik, l, j);
  if (i < r) zasobnikQSort(zasobnik, i, r);  
}*/

void zasobnikQSort(Zasobnik* zasobnik, int left, int right) {
  int l_hold, r_hold, x;
  Tah pivot;

  l_hold = left;
  r_hold = right;

  pivot = zasobnik->prvky[left];
  while (left < right)
  {
	while ((zasobnik->prvky[right].pocetObarveni >= pivot.pocetObarveni) && (left < right)) right--;
    if (left != right)
    {
      zasobnik->prvky[left] = zasobnik->prvky[right];
      left++;
    }
	while ((zasobnik->prvky[left].pocetObarveni <= pivot.pocetObarveni) && (left < right)) left++;
    if (left != right)
    {
      zasobnik->prvky[right] = zasobnik->prvky[left];
      right--;
    }
 }
 zasobnik->prvky[left] = pivot;
 x = left;
 left = l_hold;
 right = r_hold;
 if (left < x)
   zasobnikQSort(zasobnik, left, x - 1);
 if (right > x)
   zasobnikQSort(zasobnik, x + 1, right);
}


void zasobnikSeradTahyPodlePoctuObarveni(Zasobnik* zasobnik, int count) {
  if (zasobnik) {
    int i;
    if (zasobnik->velikost < count) count = zasobnik->velikost;
    zasobnikQSort(zasobnik, zasobnik->velikost - count, zasobnik->velikost - 1);
    for(i = zasobnik->velikost - count; i < zasobnik->velikost; i++) {
      zasobnik->prvky[i].pocetObarveni = 0;
    }
  }
}


void zasobnikUlozVysledek(Zasobnik* zasobnik, Vysledek* vysledek) {
  if (zasobnik && vysledek) {
    int i;
    for(i = 0; i < zasobnik->velikost; i++) {
      if (zasobnik->prvky[i].zahrany) {
        vysledekPridejPozici(vysledek, zasobnik->prvky[i].pozice);
      }
    }
  }
}
