/*
 * Decompiled with CFR 0.152.
 */
package net.michaltrs;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import net.michaltrs.Lexan;

public class OutputHTML {
    private BufferedWriter br;
    private String fileName;
    private int indent = 2;
    private boolean lw = false;

    public OutputHTML(String fileName) throws IOException {
        this.br = new BufferedWriter(new FileWriter(fileName));
        this.fileName = fileName;
    }

    public void newLine() throws IOException {
        this.write("<br>");
        this.br.newLine();
        this.ind();
        this.lw = false;
    }

    public void shLeft() throws IOException {
        --this.indent;
        this.br.newLine();
        this.ind();
        this.write("</ul>\n");
        this.ind();
        this.lw = false;
    }

    public void shRight() throws IOException {
        this.br.newLine();
        this.ind();
        this.write("<ul>");
        this.br.newLine();
        ++this.indent;
        this.ind();
        this.lw = false;
    }

    public void space() throws IOException {
        if (this.lw) {
            this.write(" ");
        }
    }

    private void ind() throws IOException {
        String s = "";
        for (int i = 0; i < this.indent; ++i) {
            s = s + "  ";
        }
        this.write(s);
        this.lw = false;
    }

    public void symbol(Lexan.LexSymbol symb) throws IOException, Exception {
        String s = "ERROR";
        boolean nl = false;
        switch (symb) {
            case symbBracOp: {
                s = "(";
                break;
            }
            case symbBracCl: {
                s = ")";
                break;
            }
            case symbComma: {
                s = ", ";
                break;
            }
            case symbColon: {
                s = ": ";
                break;
            }
            case symbVarAss: {
                s = ":= ";
                break;
            }
            case symbSigAss: {
                s = " <= ";
                break;
            }
            case symbChoice: {
                s = " => ";
                break;
            }
            case symbSemicolon: {
                s = ";";
                nl = true;
                break;
            }
            case symbDot: {
                s = ".";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Symbol neni podporovan: " + (Object)((Object)symb));
            }
        }
        this.write(s);
        if (nl) {
            this.newLine();
        }
        this.lw = false;
    }

    public void opWord(String name) throws IOException {
        this.write(" <b>" + name + "</b> ");
        this.lw = false;
    }

    public void opSymb(String name) throws IOException {
        this.write(" " + name + " ");
        this.lw = false;
    }

    public void writeNewIdent(String name, String addr) throws IOException {
        this.space();
        this.write("<a name=\"" + addr + "\"></a>" + name);
        this.lw = true;
    }

    public void writeUseIdent(String name, String addr) throws IOException {
        this.space();
        this.write("<a href=\"#" + addr + "\">" + name + "</a>");
        this.lw = true;
    }

    public void comment(String text) throws IOException {
        this.space();
        this.write("--" + text);
        this.br.newLine();
    }

    public void writeKw(String name) throws IOException {
        this.space();
        this.write("<b>" + name.toLowerCase() + "</b>");
        this.lw = true;
    }

    public void writeType(String name) throws IOException {
        this.space();
        this.write("<span id=\"type\">" + name.toLowerCase() + "</span>");
        this.lw = true;
    }

    public void writeInt(String name) throws IOException {
        this.space();
        this.write(name);
        this.lw = true;
    }

    public void writeReal(String name) throws IOException {
        this.space();
        this.write(name);
        this.lw = true;
    }

    public void writeString(String name) throws IOException {
        this.space();
        this.write("<span id=\"string\">" + name + "</span>");
        this.lw = true;
    }

    public void writeBit(String name) throws IOException {
        this.space();
        this.write("<span id=\"bit\">'" + name + "'</span>");
        this.lw = true;
    }

    private void write(String name) throws IOException {
        this.br.write(name);
    }

    public void writeAtrib(String name) throws IOException {
        this.br.write("'" + name + " ");
        this.lw = true;
    }

    public void writeHead(String header) throws IOException {
        this.br.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
        this.br.write("<html lang=\"cs\">\n");
        this.br.write("<head>\n");
        this.br.write("<meta http-equiv=\"content-type\" content=\"text/html; charset=windows-1250\">\n");
        this.br.write("<style>");
        this.br.write("#type {color: orange}");
        this.br.write("#bit  {color: green}");
        this.br.write("#string  {color: darkgreen}");
        this.br.write("#num  {color: green}");
        this.br.write("body {font-family: Courier New, Verdana, Arial, Courier, sans-serif}");
        this.br.write("a:link    {font-weight: bold; text-decoration: none; color: blue}");
        this.br.write("a:visited    {font-weight: bold; text-decoration: none; color: darkblue}");
        this.br.write("a:hover    {font-weight: bold; text-decoration: none; color: red}");
        this.br.write("</style>");
        this.br.write("<title>" + header + "</title>\n</head>\n<body>\n");
        this.br.write("<h2>" + header + "</h2>");
    }

    public void writeTail() throws IOException {
        this.br.write("</body>\n</html>");
        this.br.close();
    }

    void signum(String val) throws IOException {
        this.write(" " + val + " ");
    }
}

