/*
 * Decompiled with CFR 0.152.
 */
package net.michaltrs;

import java.io.FileNotFoundException;
import java.io.IOException;
import net.michaltrs.DeclTab;
import net.michaltrs.Lexan;
import net.michaltrs.OutputHTML;

public class Syntax {
    Lexan l;
    OutputHTML out;
    DeclTab dt;
    boolean local = false;

    public Syntax(String jmeno) {
        try {
            this.l = new Lexan(jmeno);
            this.l.CtiSymbol();
            this.out = new OutputHTML(jmeno + ".html");
            this.out.writeHead(jmeno);
            this.dt = new DeclTab();
            this.Design_file();
            this.Srovnani(Lexan.LexSymbol.symbEOF);
            this.out.writeTail();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception ex) {
            try {
                this.out.writeTail();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            System.out.println(ex.getMessage());
        }
    }

    private void Srovnani(Lexan.LexSymbol ident) throws Exception {
        if (ident == this.l.symbol) {
            if (ident.toString().contains("symbKw")) {
                ident = Lexan.LexSymbol.symbKW;
            }
            switch (ident) {
                case symbIDENT: 
                case symbEOF: {
                    break;
                }
                case symbKW: {
                    this.out.writeKw(this.l.symbVal);
                    break;
                }
                case symbSTRINGorVECTOR: {
                    this.out.writeString(this.l.symbVal);
                    break;
                }
                case symbATRIB: {
                    this.out.writeAtrib(this.l.symbVal);
                    break;
                }
                case symbINT: {
                    this.out.writeInt(this.l.symbVal);
                    break;
                }
                case symbBIT: {
                    this.out.writeBit(this.l.symbVal);
                    break;
                }
                case symbREAL: {
                    this.out.writeReal(this.l.symbVal);
                    break;
                }
                case symbSign: {
                    this.out.signum(this.l.symbVal);
                    break;
                }
                case symbOpAnd: 
                case symbOpRel: {
                    this.out.opSymb(this.l.symbVal);
                    break;
                }
                case symbOpMult: 
                case symbOpLog: 
                case symbOpLogSpec: 
                case symbOpShift: {
                    this.out.opWord(this.l.symbVal);
                    break;
                }
                case symbDataType: {
                    this.out.writeType(this.l.symbVal);
                    break;
                }
                default: {
                    this.out.symbol(ident);
                }
            }
            this.l.CtiSymbol();
            if (this.l.symbol == Lexan.LexSymbol.err) {
                throw new Exception("Chyba v lexikalni analyze");
            }
        } else {
            throw new Exception("Ocekavan: " + (Object)((Object)ident) + ", nalezen: " + (Object)((Object)this.l.symbol) + " (" + this.l.symbVal + ")");
        }
    }

    private void Declare(boolean declare) throws Exception {
        if (declare) {
            this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        } else {
            this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
        }
    }

    private void Adding_operator() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbSign) {
            this.Srovnani(Lexan.LexSymbol.symbSign);
        } else {
            this.Srovnani(Lexan.LexSymbol.symbOpAnd);
        }
    }

    private void Architecture_body() throws Exception {
        this.out.newLine();
        this.out.newLine();
        this.Srovnani(Lexan.LexSymbol.symbKwArch);
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        this.Srovnani(Lexan.LexSymbol.symbKwOf);
        this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        this.Srovnani(Lexan.LexSymbol.symbKwIs);
        this.out.shRight();
        this.Declaration_part();
        this.out.shLeft();
        this.Srovnani(Lexan.LexSymbol.symbKwBegin);
        this.local = true;
        this.out.shRight();
        this.Architecture_statement_part();
        this.out.shLeft();
        this.Srovnani(Lexan.LexSymbol.symbKwEnd);
        if (this.l.symbol == Lexan.LexSymbol.symbKwArch) {
            this.Srovnani(Lexan.LexSymbol.symbKwArch);
        }
        if (this.l.symbol == Lexan.LexSymbol.symbIDENT) {
            this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Architecture_statement_part() throws Exception {
        while (this.l.symbol == Lexan.LexSymbol.symbIDENT || this.l.symbol == Lexan.LexSymbol.symbKwProc || this.l.symbol == Lexan.LexSymbol.symbKwAssert || this.l.symbol == Lexan.LexSymbol.symbKwGen) {
            this.dt.newLocal();
            this.Concurrent_statement();
        }
    }

    private void Assertion_statement() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwAssert);
        this.Expression();
        if (this.l.symbol == Lexan.LexSymbol.symbKwReport) {
            this.Srovnani(Lexan.LexSymbol.symbKwReport);
            this.Expression();
        }
        if (this.l.symbol == Lexan.LexSymbol.symbKwSever) {
            this.Srovnani(Lexan.LexSymbol.symbKwSever);
            this.Expression();
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Attribute_name() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbATRIB);
        if (this.l.symbol == Lexan.LexSymbol.symbBracOp) {
            this.Srovnani(Lexan.LexSymbol.symbBracOp);
            this.Expression();
            this.Srovnani(Lexan.LexSymbol.symbBracCl);
        }
    }

    private void Block_declarative_item() throws Exception {
        switch (this.l.symbol) {
            case symbKwType: {
                this.Type_declaration();
                break;
            }
            case symbKwSubtype: {
                this.Subtype_declaration();
                break;
            }
            case symbKwConst: {
                this.Constant_declaration();
                break;
            }
            case symbKwSignal: {
                this.Signal_declaration();
                break;
            }
            case symbKwVar: {
                this.Variable_declaration();
                break;
            }
            case symbKwComp: {
                this.Component_declaration();
                break;
            }
            default: {
                this.Use_clause();
            }
        }
    }

    private void Case_statement() throws Exception {
        this.out.newLine();
        this.Srovnani(Lexan.LexSymbol.symbKwCase);
        this.Expression();
        this.Srovnani(Lexan.LexSymbol.symbKwIs);
        this.out.shRight();
        this.Case_statement_alternative();
        while (this.l.symbol != Lexan.LexSymbol.symbKwEnd) {
            this.Case_statement_alternative();
        }
        this.out.shLeft();
        this.Srovnani(Lexan.LexSymbol.symbKwEnd);
        this.Srovnani(Lexan.LexSymbol.symbKwCase);
        if (this.l.symbol == Lexan.LexSymbol.symbIDENT) {
            this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Case_statement_alternative() throws Exception {
        this.out.newLine();
        this.Srovnani(Lexan.LexSymbol.symbKwWhen);
        this.Choice();
        this.Srovnani(Lexan.LexSymbol.symbChoice);
        this.Sequence_of_statements();
    }

    private void Component_declaration() throws Exception {
        this.out.newLine();
        this.Srovnani(Lexan.LexSymbol.symbKwComp);
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        if (this.l.symbol == Lexan.LexSymbol.symbKwIs) {
            this.Srovnani(Lexan.LexSymbol.symbKwIs);
        }
        this.out.shRight();
        if (this.l.symbol == Lexan.LexSymbol.symbKwGenic) {
            this.Generic_clause();
        }
        if (this.l.symbol == Lexan.LexSymbol.symbKwPort) {
            this.Port_clause();
        }
        this.out.shRight();
        this.Srovnani(Lexan.LexSymbol.symbKwEnd);
        this.Srovnani(Lexan.LexSymbol.symbKwComp);
        if (this.l.symbol == Lexan.LexSymbol.symbIDENT) {
            this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Concurrent_statement() throws Exception {
        switch (this.l.symbol) {
            case symbKwProc: {
                this.Process_statement();
                break;
            }
            case symbKwAssert: {
                this.Assertion_statement();
                break;
            }
            default: {
                this.Concurrent_statement2();
            }
        }
    }

    private void Concurrent_statement2() throws Exception {
        String ident = this.l.symbVal;
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        if (this.l.symbol == Lexan.LexSymbol.symbColon) {
            this.out.newLine();
            this.out.writeNewIdent(ident, this.dt.addIdent(ident, this.local));
            this.Srovnani(Lexan.LexSymbol.symbColon);
            this.Concurrent_statement3();
        } else {
            this.out.writeUseIdent(ident, this.dt.addIdent(ident, this.local));
            this.Concurrent_statement4();
        }
    }

    private void Concurrent_statement3() throws Exception {
        switch (this.l.symbol) {
            case symbKwProc: {
                this.Process_statement();
                break;
            }
            case symbKwAssert: {
                this.Assertion_statement();
                break;
            }
            default: {
                this.Generate_statement();
            }
        }
    }

    private void Concurrent_statement4() throws Exception {
        this.Name3();
        this.Signal_assignment_statement();
    }

    private void Constant_declaration() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwConst);
        this.Name_list(true);
        this.Srovnani(Lexan.LexSymbol.symbColon);
        this.Name(true);
        if (this.l.symbol == Lexan.LexSymbol.symbVarAss) {
            this.Srovnani(Lexan.LexSymbol.symbVarAss);
            this.Expression();
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Context_item() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwLib) {
            this.Library_clause();
        } else {
            this.Use_clause();
        }
    }

    private void Declaration_part() throws Exception {
        while (this.l.symbol == Lexan.LexSymbol.symbKwType || this.l.symbol == Lexan.LexSymbol.symbKwSubtype || this.l.symbol == Lexan.LexSymbol.symbKwConst || this.l.symbol == Lexan.LexSymbol.symbKwSignal || this.l.symbol == Lexan.LexSymbol.symbKwVar || this.l.symbol == Lexan.LexSymbol.symbKwComp || this.l.symbol == Lexan.LexSymbol.symbKwUse) {
            this.Block_declarative_item();
        }
    }

    private void Design_file() throws Exception {
        this.Design_unit();
        while (this.l.symbol == Lexan.LexSymbol.symbKwLib || this.l.symbol == Lexan.LexSymbol.symbKwUse || this.l.symbol == Lexan.LexSymbol.symbKwEnt || this.l.symbol == Lexan.LexSymbol.symbKwArch) {
            this.Design_unit();
        }
    }

    private void Design_unit() throws Exception {
        while (this.l.symbol == Lexan.LexSymbol.symbKwLib || this.l.symbol == Lexan.LexSymbol.symbKwUse) {
            this.Context_item();
        }
        this.Library_unit();
    }

    private void Element_association() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwOth);
        this.Srovnani(Lexan.LexSymbol.symbChoice);
        this.Expression();
    }

    private void Entity_declaration() throws Exception {
        this.out.newLine();
        this.out.newLine();
        this.Srovnani(Lexan.LexSymbol.symbKwEnt);
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        this.Srovnani(Lexan.LexSymbol.symbKwIs);
        this.out.shRight();
        this.Entity_header();
        this.Declaration_part();
        if (this.l.symbol == Lexan.LexSymbol.symbKwBegin) {
            this.Srovnani(Lexan.LexSymbol.symbKwBegin);
            this.Entity_statement_part();
        }
        this.out.shLeft();
        this.Srovnani(Lexan.LexSymbol.symbKwEnd);
        if (this.l.symbol == Lexan.LexSymbol.symbKwEnt) {
            this.Srovnani(Lexan.LexSymbol.symbKwEnt);
        }
        if (this.l.symbol == Lexan.LexSymbol.symbIDENT) {
            this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
        this.out.newLine();
    }

    private void Entity_header() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwGenic) {
            this.Generic_clause();
        }
        if (this.l.symbol == Lexan.LexSymbol.symbKwPort) {
            this.Port_clause();
        }
    }

    private void Entity_statement() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwAssert) {
            this.Assertion_statement();
        } else {
            this.Process_statement();
        }
    }

    private void Entity_statement_part() throws Exception {
        while (this.l.symbol == Lexan.LexSymbol.symbKwAssert || this.l.symbol == Lexan.LexSymbol.symbKwProc || this.l.symbol == Lexan.LexSymbol.symbKwPost) {
            this.Entity_statement();
        }
    }

    private void Enumeration_type_definition() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbBracOp);
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        while (this.l.symbol == Lexan.LexSymbol.symbComma) {
            this.Srovnani(Lexan.LexSymbol.symbComma);
            this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        this.Srovnani(Lexan.LexSymbol.symbBracCl);
    }

    private void Expression() throws Exception {
        this.Relation();
        if (this.l.symbol == Lexan.LexSymbol.symbOpLogSpec) {
            this.Srovnani(Lexan.LexSymbol.symbOpLogSpec);
            this.Relation();
        } else {
            while (this.l.symbol == Lexan.LexSymbol.symbOpLog) {
                this.Srovnani(Lexan.LexSymbol.symbOpLog);
                this.Relation();
            }
        }
    }

    private void Factor() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwAbsNot) {
            this.Srovnani(Lexan.LexSymbol.symbKwAbsNot);
        }
        this.Primary();
    }

    private void Generate_statement() throws Exception {
        this.Generation_scheme();
        this.Srovnani(Lexan.LexSymbol.symbKwGen);
        if (this.l.symbol == Lexan.LexSymbol.symbKwType || this.l.symbol == Lexan.LexSymbol.symbKwSubtype || this.l.symbol == Lexan.LexSymbol.symbKwConst || this.l.symbol == Lexan.LexSymbol.symbKwSignal || this.l.symbol == Lexan.LexSymbol.symbKwVar || this.l.symbol == Lexan.LexSymbol.symbKwComp || this.l.symbol == Lexan.LexSymbol.symbKwUse) {
            this.Declaration_part();
            this.out.newLine();
            this.Srovnani(Lexan.LexSymbol.symbKwBegin);
        }
        this.out.shRight();
        while (this.l.symbol != Lexan.LexSymbol.symbKwEnd) {
            this.Concurrent_statement();
        }
        this.out.shLeft();
        this.Srovnani(Lexan.LexSymbol.symbKwEnd);
        this.Srovnani(Lexan.LexSymbol.symbKwGen);
        if (this.l.symbol == Lexan.LexSymbol.symbIDENT) {
            this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Generation_scheme() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwFor) {
            this.Srovnani(Lexan.LexSymbol.symbKwFor);
            this.Parameter_specification();
        } else {
            this.Srovnani(Lexan.LexSymbol.symbKwIf);
            this.Expression();
        }
    }

    private void Generic_clause() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwGenic);
        this.Srovnani(Lexan.LexSymbol.symbBracOp);
        this.out.shRight();
        this.Interface_list();
        this.out.shLeft();
        this.Srovnani(Lexan.LexSymbol.symbBracCl);
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Choice() throws Exception {
        switch (this.l.symbol) {
            case symbIDENT: {
                this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
                this.Srovnani(Lexan.LexSymbol.symbIDENT);
                break;
            }
            case symbSTRINGorVECTOR: {
                this.Srovnani(Lexan.LexSymbol.symbSTRINGorVECTOR);
                break;
            }
            default: {
                this.Srovnani(Lexan.LexSymbol.symbKwOth);
            }
        }
    }

    private void Identifier_list() throws Exception {
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        while (this.l.symbol == Lexan.LexSymbol.symbComma) {
            this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
    }

    private void If_statement() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwIf);
        this.Expression();
        this.Srovnani(Lexan.LexSymbol.symbKwThen);
        this.Sequence_of_statements();
        while (this.l.symbol == Lexan.LexSymbol.symbKwElsif) {
            this.Srovnani(Lexan.LexSymbol.symbKwElsif);
            this.Expression();
            this.Srovnani(Lexan.LexSymbol.symbKwThen);
            this.Sequence_of_statements();
        }
        if (this.l.symbol == Lexan.LexSymbol.symbKwElse) {
            this.Srovnani(Lexan.LexSymbol.symbKwElse);
            this.Sequence_of_statements();
        }
        this.Srovnani(Lexan.LexSymbol.symbKwEnd);
        this.Srovnani(Lexan.LexSymbol.symbKwIf);
        if (this.l.symbol == Lexan.LexSymbol.symbIDENT) {
            this.out.writeUseIdent(this.l.symbVal, this.dt.getIdent(this.l.symbVal));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Interface_declaration() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwConst || this.l.symbol == Lexan.LexSymbol.symbKwSignal || this.l.symbol == Lexan.LexSymbol.symbKwVar) {
            if (this.l.symbol == Lexan.LexSymbol.symbKwConst) {
                this.Srovnani(Lexan.LexSymbol.symbKwConst);
            }
            if (this.l.symbol == Lexan.LexSymbol.symbKwSignal) {
                this.Srovnani(Lexan.LexSymbol.symbKwSignal);
            }
            if (this.l.symbol == Lexan.LexSymbol.symbKwVar) {
                this.Srovnani(Lexan.LexSymbol.symbKwVar);
            }
        }
        this.Identifier_list();
        this.Srovnani(Lexan.LexSymbol.symbColon);
        if (this.l.symbol == Lexan.LexSymbol.symbKwIn || this.l.symbol == Lexan.LexSymbol.symbKwMode) {
            this.Mode();
        }
        this.Name(true);
        if (this.l.symbol == Lexan.LexSymbol.symbKwBus) {
            this.Srovnani(Lexan.LexSymbol.symbKwBus);
        }
        if (this.l.symbol == Lexan.LexSymbol.symbVarAss) {
            this.Srovnani(Lexan.LexSymbol.symbVarAss);
            this.Expression();
        }
    }

    private void Interface_list() throws Exception {
        this.Interface_declaration();
        while (this.l.symbol == Lexan.LexSymbol.symbSemicolon) {
            this.Srovnani(Lexan.LexSymbol.symbSemicolon);
            this.Interface_declaration();
        }
    }

    private void Library_clause() throws Exception {
        this.out.newLine();
        this.Srovnani(Lexan.LexSymbol.symbKwLib);
        this.Name_list(true);
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Library_unit() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwEnt) {
            this.Entity_declaration();
        } else {
            this.Architecture_body();
        }
    }

    private void Literal() throws Exception {
        switch (this.l.symbol) {
            case symbINT: {
                this.Srovnani(Lexan.LexSymbol.symbINT);
                break;
            }
            case symbREAL: {
                this.Srovnani(Lexan.LexSymbol.symbREAL);
                break;
            }
            case symbSTRINGorVECTOR: {
                this.Srovnani(Lexan.LexSymbol.symbSTRINGorVECTOR);
                break;
            }
            case symbBIT: {
                this.Srovnani(Lexan.LexSymbol.symbBIT);
                break;
            }
            default: {
                this.Srovnani(Lexan.LexSymbol.symbKwNull);
            }
        }
    }

    private void Mode() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwIn) {
            this.Srovnani(Lexan.LexSymbol.symbKwIn);
        } else {
            this.Srovnani(Lexan.LexSymbol.symbKwMode);
        }
    }

    private void Name(boolean declare) throws Exception {
        switch (this.l.symbol) {
            case symbSTRINGorVECTOR: {
                this.Srovnani(Lexan.LexSymbol.symbSTRINGorVECTOR);
                break;
            }
            case symbVECTOR: {
                this.Srovnani(Lexan.LexSymbol.symbVECTOR);
                break;
            }
            case symbDataType: {
                this.Srovnani(Lexan.LexSymbol.symbDataType);
                this.Name3();
                break;
            }
            default: {
                this.Name2(declare);
            }
        }
    }

    private void Name2(boolean declare) throws Exception {
        this.Declare(declare);
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        this.Name3();
    }

    private void Name3() throws Exception {
        switch (this.l.symbol) {
            case symbATRIB: {
                this.Attribute_name();
                break;
            }
            case symbDot: {
                this.Selected_name();
                break;
            }
            case symbBracOp: {
                this.Slice_name();
            }
        }
    }

    private void Name_list(boolean declare) throws Exception {
        this.Declare(declare);
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        while (this.l.symbol == Lexan.LexSymbol.symbComma) {
            this.Srovnani(Lexan.LexSymbol.symbComma);
            this.Declare(declare);
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
    }

    private void Null_statement() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwNull);
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Parameter_specification() throws Exception {
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        this.Srovnani(Lexan.LexSymbol.symbKwIn);
        this.Range();
    }

    private void Port_clause() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwPort);
        this.Srovnani(Lexan.LexSymbol.symbBracOp);
        this.out.shRight();
        this.Interface_list();
        this.out.shLeft();
        this.Srovnani(Lexan.LexSymbol.symbBracCl);
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Prefix() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwAll) {
            this.Srovnani(Lexan.LexSymbol.symbKwAll);
        } else {
            this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
            this.Srovnani(Lexan.LexSymbol.symbDot);
            this.Prefix();
        }
    }

    private void Primary() throws Exception {
        switch (this.l.symbol) {
            case symbBracOp: {
                this.Srovnani(Lexan.LexSymbol.symbBracOp);
                this.Expression();
                this.Srovnani(Lexan.LexSymbol.symbBracCl);
                break;
            }
            case symbSTRINGorVECTOR: 
            case symbINT: 
            case symbBIT: 
            case symbREAL: 
            case symbKwNull: {
                this.Literal();
                break;
            }
            case symbKwOth: {
                this.Element_association();
                break;
            }
            default: {
                this.Name(false);
            }
        }
    }

    private void Process_declarative_item() throws Exception {
        switch (this.l.symbol) {
            case symbKwType: {
                this.Type_declaration();
                break;
            }
            case symbKwSubtype: {
                this.Subtype_declaration();
                break;
            }
            case symbKwConst: {
                this.Constant_declaration();
                break;
            }
            case symbKwVar: {
                this.Variable_declaration();
                break;
            }
            default: {
                this.Use_clause();
            }
        }
    }

    private void Process_declarative_part() throws Exception {
        while (this.l.symbol == Lexan.LexSymbol.symbKwType || this.l.symbol == Lexan.LexSymbol.symbKwSubtype || this.l.symbol == Lexan.LexSymbol.symbKwConst || this.l.symbol == Lexan.LexSymbol.symbKwVar || this.l.symbol == Lexan.LexSymbol.symbKwUse) {
            this.Process_declarative_item();
        }
    }

    private void Process_statement() throws Exception {
        this.out.newLine();
        if (this.l.symbol == Lexan.LexSymbol.symbKwPost) {
            this.Srovnani(Lexan.LexSymbol.symbKwPost);
        }
        this.Srovnani(Lexan.LexSymbol.symbKwProc);
        if (this.l.symbol == Lexan.LexSymbol.symbBracOp) {
            this.Srovnani(Lexan.LexSymbol.symbBracOp);
            this.Name_list(false);
            this.Srovnani(Lexan.LexSymbol.symbBracCl);
        }
        if (this.l.symbol == Lexan.LexSymbol.symbKwIs) {
            this.Srovnani(Lexan.LexSymbol.symbKwIs);
        }
        this.out.shRight();
        this.Process_declarative_part();
        this.out.shLeft();
        this.Srovnani(Lexan.LexSymbol.symbKwBegin);
        this.Sequence_of_statements();
        this.Srovnani(Lexan.LexSymbol.symbKwEnd);
        if (this.l.symbol == Lexan.LexSymbol.symbKwPost) {
            this.Srovnani(Lexan.LexSymbol.symbKwPost);
        }
        this.Srovnani(Lexan.LexSymbol.symbKwProc);
        if (this.l.symbol == Lexan.LexSymbol.symbIDENT) {
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Range() throws Exception {
        this.Simple_expression();
        if (this.l.symbol == Lexan.LexSymbol.symbKwDir) {
            this.Srovnani(Lexan.LexSymbol.symbKwDir);
            this.Simple_expression();
        }
    }

    private void Relation() throws Exception {
        this.Shift_expression();
        if (this.l.symbol == Lexan.LexSymbol.symbOpRel || this.l.symbol == Lexan.LexSymbol.symbSigAss) {
            this.Relational_operator();
            this.Shift_expression();
        }
    }

    private void Relational_operator() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbOpRel) {
            this.Srovnani(Lexan.LexSymbol.symbOpRel);
        } else {
            this.Srovnani(Lexan.LexSymbol.symbSigAss);
        }
    }

    private void Selected_name() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbDot);
        this.Prefix();
    }

    private void Sequence_of_statements() throws Exception {
        while (this.l.symbol == Lexan.LexSymbol.symbKwWait || this.l.symbol == Lexan.LexSymbol.symbKwAssert || this.l.symbol == Lexan.LexSymbol.symbKwIf || this.l.symbol == Lexan.LexSymbol.symbKwCase || this.l.symbol == Lexan.LexSymbol.symbKwNull || this.l.symbol == Lexan.LexSymbol.symbIDENT) {
            this.out.shRight();
            this.Sequential_statement();
            this.out.shLeft();
        }
    }

    private void Sequential_statement() throws Exception {
        switch (this.l.symbol) {
            case symbKwWait: {
                this.Wait_statement();
                break;
            }
            case symbKwAssert: {
                this.Assertion_statement();
                break;
            }
            case symbKwIf: {
                this.If_statement();
                break;
            }
            case symbKwCase: {
                this.Case_statement();
                break;
            }
            case symbKwNull: {
                this.Null_statement();
                break;
            }
            default: {
                this.Sequential_statement2();
            }
        }
    }

    private void Sequential_statement2() throws Exception {
        String ident = this.l.symbVal;
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        if (this.l.symbol == Lexan.LexSymbol.symbColon) {
            this.Srovnani(Lexan.LexSymbol.symbColon);
            this.out.writeNewIdent(ident, this.dt.addIdent(ident, this.local));
            this.Sequential_statement3();
        } else {
            this.out.writeUseIdent(ident, this.dt.getIdent(ident));
            this.Sequential_statement4();
        }
    }

    private void Sequential_statement3() throws Exception {
        switch (this.l.symbol) {
            case symbKwWait: {
                this.Wait_statement();
                break;
            }
            case symbKwAssert: {
                this.Assertion_statement();
                break;
            }
            case symbKwIf: {
                this.If_statement();
                break;
            }
            case symbKwCase: {
                this.Case_statement();
                break;
            }
            default: {
                this.Null_statement();
            }
        }
    }

    private void Sequential_statement4() throws Exception {
        this.Name3();
        if (this.l.symbol == Lexan.LexSymbol.symbVarAss) {
            this.Variable_assignment_statement();
        } else {
            this.Signal_assignment_statement();
        }
    }

    private void Shift_expression() throws Exception {
        this.Simple_expression();
        if (this.l.symbol == Lexan.LexSymbol.symbOpShift) {
            this.Srovnani(Lexan.LexSymbol.symbOpShift);
            this.Simple_expression();
        }
    }

    private void Signal_assignment_statement() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbSigAss);
        this.Waveform();
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Signal_declaration() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwSignal);
        this.Name_list(true);
        this.Srovnani(Lexan.LexSymbol.symbColon);
        this.Name(false);
        if (this.l.symbol == Lexan.LexSymbol.symbKwReg || this.l.symbol == Lexan.LexSymbol.symbKwBus) {
            if (this.l.symbol == Lexan.LexSymbol.symbKwReg) {
                this.Srovnani(Lexan.LexSymbol.symbKwReg);
            } else {
                this.Srovnani(Lexan.LexSymbol.symbKwBus);
            }
        }
        if (this.l.symbol == Lexan.LexSymbol.symbVarAss) {
            this.Srovnani(Lexan.LexSymbol.symbVarAss);
            this.Expression();
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Simple_expression() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbSign) {
            this.Srovnani(Lexan.LexSymbol.symbSign);
        }
        this.Term();
        while (this.l.symbol == Lexan.LexSymbol.symbSign || this.l.symbol == Lexan.LexSymbol.symbOpAnd) {
            this.Adding_operator();
            this.Term();
        }
    }

    private void Slice_name() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbBracOp);
        this.Range();
        this.Srovnani(Lexan.LexSymbol.symbBracCl);
    }

    private void Subtype_declaration() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwSubtype);
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        this.Srovnani(Lexan.LexSymbol.symbKwIs);
        this.Name(false);
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Term() throws Exception {
        this.Factor();
        while (this.l.symbol == Lexan.LexSymbol.symbOpMult) {
            this.Srovnani(Lexan.LexSymbol.symbOpMult);
            this.Factor();
        }
    }

    private void Type_declaration() throws Exception {
        this.out.newLine();
        this.Srovnani(Lexan.LexSymbol.symbKwType);
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        if (this.l.symbol == Lexan.LexSymbol.symbKwIs) {
            this.Srovnani(Lexan.LexSymbol.symbKwIs);
            this.Enumeration_type_definition();
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Use_clause() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbKwUse);
        this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
        this.Srovnani(Lexan.LexSymbol.symbIDENT);
        this.Selected_name();
        while (this.l.symbol == Lexan.LexSymbol.symbComma) {
            this.Srovnani(Lexan.LexSymbol.symbComma);
            this.out.writeNewIdent(this.l.symbVal, this.dt.addIdent(this.l.symbVal, this.local));
            this.Srovnani(Lexan.LexSymbol.symbIDENT);
            this.Selected_name();
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Variable_assignment_statement() throws Exception {
        this.Srovnani(Lexan.LexSymbol.symbVarAss);
        this.Expression();
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Variable_declaration() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwShared) {
            this.Srovnani(Lexan.LexSymbol.symbKwShared);
        }
        this.Srovnani(Lexan.LexSymbol.symbKwVar);
        this.Name_list(true);
        this.Srovnani(Lexan.LexSymbol.symbColon);
        this.Name(true);
        if (this.l.symbol == Lexan.LexSymbol.symbVarAss) {
            this.Srovnani(Lexan.LexSymbol.symbVarAss);
            this.Expression();
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Wait_statement() throws Exception {
        this.out.newLine();
        this.Srovnani(Lexan.LexSymbol.symbKwWait);
        if (this.l.symbol == Lexan.LexSymbol.symbKwOn) {
            this.Srovnani(Lexan.LexSymbol.symbKwOn);
            this.Name_list(false);
        }
        if (this.l.symbol == Lexan.LexSymbol.symbKwUntil) {
            this.Srovnani(Lexan.LexSymbol.symbKwUntil);
            this.Expression();
        }
        if (this.l.symbol == Lexan.LexSymbol.symbKwFor) {
            this.Srovnani(Lexan.LexSymbol.symbKwFor);
            this.Expression();
        }
        this.Srovnani(Lexan.LexSymbol.symbSemicolon);
    }

    private void Waveform() throws Exception {
        if (this.l.symbol == Lexan.LexSymbol.symbKwNull) {
            this.Srovnani(Lexan.LexSymbol.symbKwNull);
            if (this.l.symbol == Lexan.LexSymbol.symbKwAfter) {
                this.Srovnani(Lexan.LexSymbol.symbKwAfter);
                this.Expression();
            }
        } else {
            this.Expression();
            if (this.l.symbol == Lexan.LexSymbol.symbKwAfter) {
                this.Srovnani(Lexan.LexSymbol.symbKwAfter);
                this.Expression();
            }
        }
    }
}

