/*
 * Lexan.java
 *
 * Created on 29. prosinec 2005, 20:21
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package net.michaltrs;

import java.io.FileNotFoundException;
import java.util.*;

/**
 *
 * @author Misak
 */
public class Lexan {
    Vstup v;

    private enum VstupSymb {acdf, e, xo, b, ch, n1, n6, n28, n, bar, dot, minus, apo,
        quote, slash, equals, colon, less, greater, under, otherSymb, other, end, ws};
    
    private enum Stavy {sta,q0,q1,q2,q3,q4,q5,q6,q7,q8,q9,q10,q11,q12,q13,q14,q15,
        q16,q17,q18,q19,q20,q21,q22,q23,q24,q25,q26,end,err };
            
    public enum LexSymbol {
        symbINT, symbREAL, symbIDENTorKW, symbIDENT,
        symbSTRINGorVECTOR,symbSTRING,symbVECTOR,symbBIT,symbATRIB,
        symbCOMMENT, symbSPEC,symbEOF, err,
        symbDataType,
    // kw    
        symbKW,         // common, use in output
        symbKwAbsNot,   // abs, not
        symbKwAfter,    // after
        symbKwAll,      // use
        symbKwArch, // architekture
        symbKwAssert,   // assert
        symbKwBegin,// begin
        symbKwBus,      // bus
        symbKwCase,     // case
        symbKwComp,     // component
        symbKwConst,    // constant 
        symbKwDir,   // to | downto
        symbKwElse,     // else
        symbKwElsif,    // elsif
        symbKwEnd,  // end
        symbKwEnt,  // entity
        symbKwFor,      // symbKwFor
        symbKwGen,      // generate
        symbKwGenic,      // generic
        symbKwIf,       // if
        symbKwIn,       // in
        symbKwIs,   // is
        symbKwLib,    // library
        symbKwMode,     // out | inout | buffer | linkage
        symbKwName,     // name
        symbKwNull,     // null
        symbKwOf,   // of
        symbKwOn,       // on
        symbKwOth,      // others
        symbKwPort,     // port
        symbKwPost,      // postponed
        symbKwProc,     // process
        symbKwReg,      // register
        symbKwReport, // report
        symbKwRet,      // return
        symbKwSever,    // severity
        symbKwShared,   // shared
        symbKwSignal,   // signal
        symbKwSubtype,  // subtype
        symbKwThen,     // then  
        symbKwType,     // type
        symbKwUnaff,    // unaffected
        symbKwUntil,    // until
        symbKwUse,      // all
        symbKwVar,      // variable
        symbKwWait,     // wait
        symbKwWhen,     // when

    // operators
        symbSign,      // + | -
        symbOpAnd,     // &
        symbOpMult,    // * | / | mod | rem  
        symbOpLog,     // and | or | xor | xnor
        symbOpLogSpec, // nand | nor 
        symbOpShift,   // sll | srl | sla | sra | rol | ror
        symbOpRel,      // = | /= | < | > | >=

        symbBracOp,   // (
        symbBracCl,   // )
        symbComma,    // ,
        symbColon,    // :
        symbVarAss,   // :=
        symbSigAss,   // <=
        symbChoice,   // =>
        symbSemicolon, // ;
        symbDot       // .
    };
                    
              
    
    private void A0() {symbol = LexSymbol.symbIDENTorKW; symbVal = znak ;}
    private void A1() {symbVal += znak;}
    private void A2() {symbol = LexSymbol.symbVECTOR; symbVal += znak ;}
    private void A3() {symbol = LexSymbol.symbSPEC; symbVal = znak;}
    private void A4() {symbol = LexSymbol.symbSTRINGorVECTOR; symbVal = znak ;}
    private void A5() {symbVal = znak;}
    private void A6() {symbol = LexSymbol.symbBIT;}
    private void A7() {symbol = LexSymbol.symbATRIB; symbVal += znak;}
    private void A8() {symbol = LexSymbol.symbINT; symbVal = znak;}
    private void A9() {symbol = LexSymbol.symbREAL; symbVal += znak;}
    private void A10(){symbol = LexSymbol.symbCOMMENT; symbVal = v.ctiRadku();} 
    private void A11(){symbol = LexSymbol.symbEOF; symbVal = null;}
    private void Ae() {symbol = LexSymbol.err; symbVal += znak;}
        
    
    VstupSymb vstup;
    String znak;
    
    public LexSymbol symbol;
    public String symbVal;
    
    private Stavy[][] TabPrech = new Stavy[][] {
               //    acdf,        e,       xo,        b,       ch,       n1,       n6,      n28,        n,       bar,      dot,      mns,      apo,      qte,      sls,      equ,      col,      les,      grt,      udr,      oSy,      oth,      end,       ws};
        /*sta*/ {Stavy.q0, Stavy.q0, Stavy.q1, Stavy.q1, Stavy.q0, Stavy.q7, Stavy.q14,Stavy.q9, Stavy.q14,Stavy.err,Stavy.q26,Stavy.q21,Stavy.q4, Stavy.q3, Stavy.q20,Stavy.q22,Stavy.q23,Stavy.q24,Stavy.q25,Stavy.q26,Stavy.q26,Stavy.q26,Stavy.end,Stavy.sta},
        /*q0 */ {Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.q0, Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q1 */ {Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0, Stavy.q0 ,Stavy.q0, Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.q2, Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.q0, Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q2 */ {Stavy.q2, Stavy.q2, Stavy.err,Stavy.q2, Stavy.err,Stavy.q2, Stavy.q2, Stavy.q2, Stavy.q2, Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q3 */ {Stavy.q3, Stavy.q3, Stavy.q3, Stavy.q3, Stavy.q3, Stavy.q3, Stavy.q3, Stavy.q3, Stavy.q3, Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q3, Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q4 */ {Stavy.q5, Stavy.q5, Stavy.q5, Stavy.q5, Stavy.q5, Stavy.q5, Stavy.err,Stavy.err,Stavy.q5, Stavy.err,Stavy.err,Stavy.q5, Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q5 */ {Stavy.q6, Stavy.q6, Stavy.q6, Stavy.q6, Stavy.q6, Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q6 */ {Stavy.q6, Stavy.q6, Stavy.q6, Stavy.q6, Stavy.q6, Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q7 */ {Stavy.err,Stavy.q16,Stavy.err,Stavy.err,Stavy.err,Stavy.q14,Stavy.q8, Stavy.q14,Stavy.q14,Stavy.err,Stavy.q15,Stavy.end,Stavy.err,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q8 */ {Stavy.err,Stavy.q16,Stavy.err,Stavy.err,Stavy.err,Stavy.q14,Stavy.q14,Stavy.q14,Stavy.q14,Stavy.q10,Stavy.q15,Stavy.end,Stavy.err,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q9 */ {Stavy.err,Stavy.q16,Stavy.err,Stavy.err,Stavy.err,Stavy.q14,Stavy.q14,Stavy.q14,Stavy.q14,Stavy.q10,Stavy.q15,Stavy.end,Stavy.err,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q10*/ {Stavy.q11,Stavy.q11,Stavy.err,Stavy.q11,Stavy.err,Stavy.q11,Stavy.q11,Stavy.q11,Stavy.q11,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q11*/ {Stavy.q11,Stavy.q11,Stavy.err,Stavy.q11,Stavy.err,Stavy.q11,Stavy.q11,Stavy.q11,Stavy.q11,Stavy.q26,Stavy.q12,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q12*/ {Stavy.q13,Stavy.q13,Stavy.err,Stavy.q13,Stavy.err,Stavy.q13,Stavy.q13,Stavy.q13,Stavy.q13,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q13*/ {Stavy.q13,Stavy.q13,Stavy.err,Stavy.q13,Stavy.err,Stavy.q13,Stavy.q13,Stavy.q13,Stavy.q13,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q14*/ {Stavy.err,Stavy.q16,Stavy.err,Stavy.err,Stavy.err,Stavy.q14,Stavy.q14,Stavy.q14,Stavy.q14,Stavy.err,Stavy.q15,Stavy.end,Stavy.err,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q15*/ {Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q17,Stavy.q17,Stavy.q17,Stavy.q17,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q16*/ {Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q18,Stavy.q18,Stavy.q18,Stavy.q18,Stavy.err,Stavy.err,Stavy.q19,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q17*/ {Stavy.err,Stavy.q16,Stavy.err,Stavy.err,Stavy.err,Stavy.q17,Stavy.q17,Stavy.q17,Stavy.q17,Stavy.err,Stavy.err,Stavy.end,Stavy.err,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q18*/ {Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q18,Stavy.q18,Stavy.q18,Stavy.q18,Stavy.err,Stavy.err,Stavy.end,Stavy.err,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.end,Stavy.err,Stavy.end,Stavy.end},
        /*q19*/ {Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q18,Stavy.q18,Stavy.q18,Stavy.q18,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err},
        /*q20*/ {Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.end,Stavy.end},
        /*q21*/ {Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.err,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.end,Stavy.end},
        /*q22*/ {Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.end,Stavy.end},
        /*q23*/ {Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.end,Stavy.end},
        /*q24*/ {Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q26,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.end,Stavy.end},
        /*q25*/ {Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.q25,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.err,Stavy.end,Stavy.end},
        /*q26*/ {Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.end,Stavy.err,Stavy.end,Stavy.end,Stavy.end,Stavy.end}
        
    };
    
    
    private int[][] TabAkci = new int[][] {
        //      {acd,  e, xo,  b, ch, n1, n6,n28,  n,bar,dot,mns,apo,qte,sls,equ,col,les,grt,udr,oSy,oth,end, ws};
        /*sta*/ {  0,  0,  0,  0,  0,  8,  8,  8,  8, -2,  3,  3, -1,  4,  3,  3,  3,  3,  3, -2,  3, -2, 11, -1},
        /*q0 */ {  1,  1,  1,  1,  1,  1,  1,  1,  1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1,  1, -1, -2, -1, -1},
        /*q1 */ {  1,  1,  1,  1,  1,  1,  1,  1,  1, -2, -1, -1, -1,  2, -1, -1, -1, -1, -1,  1, -1, -2, -1, -1},
        /*q2 */ {  1,  1,  1,  1,  1,  1,  1,  1,  1, -2, -2, -2, -2,  1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
        /*q3 */ {  1,  1,  1,  1,  1,  1,  1,  1,  1, -2, -2, -2, -2,  1, -2, -2, -2, -2, -2,  1, -2, -2, -2, -2},
        /*q4 */ {  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5},
        /*q5 */ {  7,  7,  7,  7,  7, -2, -2, -2, -2, -2, -2, -2,  6, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
        /*q6 */ {  1,  1,  1,  1,  1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1},
        /*q7 */ { -1,  1, -1, -1, -1,  1,  1,  1,  1, -2,  9, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1},
        /*q8 */ { -1,  1, -1, -1, -1, -1, -1, -1, -1,  1,  9, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1},
        /*q9 */ { -1,  1, -1, -1, -1,  1,  1,  1,  1,  1,  9, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1},
        /*q10*/ {  1,  1, -2,  1, -2,  1,  1,  1,  1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
        /*q11*/ {  1,  1, -2,  1, -2,  1,  1,  1,  1,  1,  9, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
        /*q12*/ {  1,  1, -2,  1, -2,  1,  1,  1,  1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},                
        /*q13*/ {  1,  1, -2,  1, -2,  1,  1,  1,  1,  1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
        /*q14*/ { -2,  1, -2, -2, -2,  1,  1,  1,  1, -2,  9, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1},
        /*q15*/ { -2, -2, -2, -2, -2,  1,  1,  1,  1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
        /*q16*/ { -2, -2, -2, -2, -2,  1,  1,  1,  1, -2, -2,  1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
        /*q17*/ { -1,  1, -1, -1, -1,  1,  1,  1,  1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1},
        /*q18*/ { -1, -1, -1, -1, -1,  1,  1,  1,  1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -1},
        /*q19*/ { -2, -2, -2, -2, -2,  1,  1,  1,  1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},
        /*q20*/ { -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2,  1, -2, -2, -2, -2, -1, -2, -1, -1},
        /*q21*/ { -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, 10, -2, -2, -2, -2, -2, -2, -2, -2, -1, -2, -1, -1},
        /*q22*/ { -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -1, -1, -2, -2, -2, -2,  1, -2, -1, -2, -1, -1},
        /*q23*/ { -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -1, -1, -2,  1, -2, -2, -2, -2, -1, -2, -1, -1},
        /*q24*/ { -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -1, -1, -2,  1, -2, -2, -2, -2, -1, -2, -1, -1},
        /*q25*/ { -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -1, -1, -2,  1, -2, -2, -2, -2, -1, -2, -1, -1},
        /*q26*/ { -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1},  
        /*end*/ { -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -2, -1, -1},                  
        /*err*/ { -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2},                  
    };
    
    private void Akce(int stav, int vstup) {
        int i = TabAkci[stav][vstup];
        switch (i) {
            case 0: A0(); break;
            case 1: A1(); break;
            case 2: A2(); break;      
            case 3: A3(); break;
            case 4: A4(); break;
            case 5: A5(); break;
            case 6: A6(); break;
            case 7: A7(); break;
            case 8: A8(); break;                
            case 9: A9(); break;
            case 10:A10();break;   
            case 11:A11();break;
            case -2:Ae(); break;
        }
    }
    
    /* unsuported kws
        access", "alias", "array", "attribute", "block", "body", "configuration", 
        "disconnect", "exit", "file", "function", "group", "guarded", "impure", 
        "inertial", "label", "literal", "loop", "map", "new", "next", "notv", 
        "open", "package", "procedure", "pure", "range", "record", "register", 
        "reject", "return", "select", "transport", "units", "while", "with",
    */
    
    
    private Map kws = new HashMap();    
    private void initKWs() {
        kws.put("abs",LexSymbol.symbKwAbsNot);
        kws.put("after",LexSymbol.symbKwAfter);
        kws.put("all",LexSymbol.symbKwAll);
        kws.put("architecture",LexSymbol.symbKwArch);
        kws.put("assert",LexSymbol.symbKwAssert);
        kws.put("begin",LexSymbol.symbKwBegin);
        kws.put("buffer",LexSymbol.symbKwMode);
        kws.put("bus",LexSymbol.symbKwBus);
        kws.put("case",LexSymbol.symbKwCase);
        kws.put("component",LexSymbol.symbKwComp);
        kws.put("constant",LexSymbol.symbKwConst);
        kws.put("downto",LexSymbol.symbKwDir);
        kws.put("else",LexSymbol.symbKwElse);
        kws.put("elsif",LexSymbol.symbKwElsif);
        kws.put("end",LexSymbol.symbKwEnd);
        kws.put("entity",LexSymbol.symbKwEnt);
        kws.put("for",LexSymbol.symbKwFor);
        kws.put("generate",LexSymbol.symbKwGen);                
        kws.put("generic",LexSymbol.symbKwGenic);
        kws.put("if",LexSymbol.symbKwIf);
        kws.put("in",LexSymbol.symbKwIn);
        kws.put("inout",LexSymbol.symbKwMode);
        kws.put("is",LexSymbol.symbKwIs);
        kws.put("library",LexSymbol.symbKwLib);
        kws.put("linkage",LexSymbol.symbKwMode);
        kws.put("name",LexSymbol.symbKwName);
        kws.put("not",LexSymbol.symbKwAbsNot);
        kws.put("null",LexSymbol.symbKwNull);
        kws.put("of",LexSymbol.symbKwOf);
        kws.put("on",LexSymbol.symbKwOn);
        kws.put("others",LexSymbol.symbKwOth);
        kws.put("out",LexSymbol.symbKwMode);
        kws.put("port",LexSymbol.symbKwPort);
        kws.put("postponed",LexSymbol.symbKwPost);
        kws.put("process",LexSymbol.symbKwProc);
        kws.put("register",LexSymbol.symbKwReg);
        kws.put("report",LexSymbol.symbKwReport);
        kws.put("return",LexSymbol.symbKwRet);                        
        kws.put("severity",LexSymbol.symbKwSever);
        kws.put("shared",LexSymbol.symbKwShared);
        kws.put("signal",LexSymbol.symbKwSignal);
        kws.put("subtype", LexSymbol.symbKwSubtype);
        kws.put("then",LexSymbol.symbKwThen);
        kws.put("to",LexSymbol.symbKwDir);
        kws.put("type",LexSymbol.symbKwType);
        kws.put("unaffected",LexSymbol.symbKwUnaff);                
        kws.put("until",LexSymbol.symbKwUntil);
        kws.put("use",LexSymbol.symbKwUse);
        kws.put("variable",LexSymbol.symbKwVar);
        kws.put("wait",LexSymbol.symbKwWait);
        kws.put("when",LexSymbol.symbKwWhen);
        
        kws.put("mod",LexSymbol.symbOpMult);
        kws.put("rem",LexSymbol.symbOpMult);
        kws.put("and",LexSymbol.symbOpLog);                
        kws.put("or",LexSymbol.symbOpLog);
        kws.put("xor",LexSymbol.symbOpLog);
        kws.put("xnor",LexSymbol.symbOpLog);                
        kws.put("nand",LexSymbol.symbOpLogSpec);
        kws.put("nor",LexSymbol.symbOpLogSpec);
        kws.put("sll",LexSymbol.symbOpShift);
        kws.put("srl",LexSymbol.symbOpShift);
        kws.put("sla",LexSymbol.symbOpShift);
        kws.put("sra",LexSymbol.symbOpShift);                
        kws.put("rol",LexSymbol.symbOpShift);
        kws.put("ror",LexSymbol.symbOpShift);
    }
    
    private Map ops = new HashMap();
    private void initOPs() {
        ops.put("+",LexSymbol.symbSign);
        ops.put("-",LexSymbol.symbSign);
        ops.put("&",LexSymbol.symbOpAnd);
        ops.put("*",LexSymbol.symbOpMult);
        ops.put("/",LexSymbol.symbOpMult);
        ops.put("=",LexSymbol.symbOpRel);
        ops.put("/=",LexSymbol.symbOpRel);
        ops.put("<",LexSymbol.symbOpRel);
        ops.put(">",LexSymbol.symbOpRel);
        ops.put(">=",LexSymbol.symbOpRel);
        ops.put("(",LexSymbol.symbBracOp);
        ops.put(")",LexSymbol.symbBracCl);
        ops.put(",",LexSymbol.symbComma);
        ops.put(":",LexSymbol.symbColon);
        ops.put(":=",LexSymbol.symbVarAss);
        ops.put("<=",LexSymbol.symbSigAss);
        ops.put("=>",LexSymbol.symbChoice);
        ops.put(";",LexSymbol.symbSemicolon);
        ops.put(".",LexSymbol.symbDot);
    }
    
    private List ts = new ArrayList();
    private void initTypes() {
        ts.add("integer");
        ts.add("std_logic");
        ts.add("std_logic_vector");
    }
                
                          
    
    private void isKW() {
        String s = symbVal.toLowerCase();
        if (kws.containsKey(s))
            symbol = (LexSymbol) kws.get(s);
        else                
            symbol = LexSymbol.symbIDENT;
    }
    
    private void isType() {
        String s = symbVal.toLowerCase();
        if (ts.contains(s))
            symbol = LexSymbol.symbDataType;
    }
    
    private void Op() {
        if (ops.containsKey(symbVal))
            symbol = (LexSymbol) ops.get(symbVal);
    }
    
    
    /** Creates a new instance of Lexan */
    public Lexan(String jmeno) throws FileNotFoundException {
        v = new Vstup(jmeno);
        ctiVstup();
        // inicializece klicovych slov
        initKWs();
        initOPs();
        initTypes();
    }
    
    private void ctiVstup() {
       int ch = v.ctiZnak();
       if (ch == -1) {
           vstup = VstupSymb.end;
           return;
       }
       
       znak = Character.toString((char)ch);
       char z = Character.toLowerCase((char) ch);
               
       
       if (z == ' ' || z == '\t' || z == '\n' || z == '\r') {
           vstup = VstupSymb.ws;
       } else if (z == 'a' || z == 'c' || z == 'd' || z == 'f') {
           vstup = VstupSymb.acdf;
       } else if (z == 'e') {
           vstup = VstupSymb.e;
        } else if (z == 'x' || z == 'o') {
           vstup = VstupSymb.xo; 
        } else if (z == 'b') {
           vstup = VstupSymb.b;
        } else if (z >= 'a' && z <= 'z') {
           vstup = VstupSymb.ch;
        } else if (z == '1') {
           vstup = VstupSymb.n1;
        } else if (z == '6') {
           vstup = VstupSymb.n6;
        } else if (z == '2' || z == '8') {
           vstup = VstupSymb.n28;
        } else if (z >= '0' && z <= '9') {
           vstup = VstupSymb.n;
        } else if (z == '#') {
           vstup = VstupSymb.bar;
        } else if (z == '.') {
           vstup = VstupSymb.dot;
        } else if (z == '-') {
           vstup = VstupSymb.minus;
        } else if (z == '\'') {
           vstup = VstupSymb.apo;
        } else if (z == '"') {
           vstup = VstupSymb.quote;
        } else if (z == '/') {
           vstup = VstupSymb.slash;
        } else if (z == '=') {
           vstup = VstupSymb.equals;
        } else if (z ==':') {
           vstup = VstupSymb.colon;
        } else if (z =='<') {
           vstup = VstupSymb.less;
        } else if (z =='>') {
           vstup = VstupSymb.greater;
        } else if (z =='_') {
           vstup = VstupSymb.under;
        } else if (z =='&' || z ==',' || z ==';' || z =='+' || z =='*' || z =='(' || z ==')') {
           vstup = VstupSymb.otherSymb;
        } else
           vstup = VstupSymb.other; 
    }
    
    public void CtiSymbol() {
        Stavy stav = Stavy.sta;
       
        while (vstup == VstupSymb.ws) {
            ctiVstup();
        }
        
        while ((stav != Stavy.err) && stav != Stavy.end) {
            Akce(stav.ordinal(), vstup.ordinal());
            stav = TabPrech[stav.ordinal()][vstup.ordinal()];
            //konec = KoncStavy[stav.ordinal()];
            if ((stav != Stavy.end) && (stav != Stavy.err)) ctiVstup();
        } 
        
        if (symbol == LexSymbol.symbIDENTorKW) isKW();
        if (symbol == LexSymbol.symbSPEC) Op();
        if (symbol == LexSymbol.symbIDENT) isType();
        
        while (symbol == LexSymbol.symbCOMMENT) {
                System.out.println("--" + symbVal);
                CtiSymbol();
        }
    }
    
}
