/*
  Name: main.c
  Copyright: 
  Author: Michal Trs
  Date: May 2005
  Description: basic EXIF reader
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pfunc.h"
#include "data.h"
#include "mem.h"

/* variable declaration */



FILE *f;
 
unsigned long int i;

unsigned char buf, buf4[4]; 
unsigned int buf16;
 
unsigned long int EXIFoffset=0, GPSoffset=0, INTERoffset=0, MAKERoffset=0; 

int err, decodeval=1;

/* function declaration */


/* read IFD entry from memory */
void getIFD(unsigned int *tagNumber, unsigned int *type, unsigned long int *coc, unsigned long int *index) {
  if (tagNumber) *tagNumber = getSHORT(memIndex);
  if (type)      *type = getSHORT(memIndex+2);
  if (coc)       *coc = getLONG(memIndex+4);
  if (index)     *index = memIndex+8;
  memIndex += 12;
}

int skipJFIF(void) {
  int skip, i;
  
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
     skip = 0x100 * buf; 
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
     skip += buf;  

  for (i=skip; i > 0; i--)
    if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
  
  return 0;
}

int readAPP1header(void) {
  int ret=0;
  
  /* read SOI Marker */ 
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2; 
  if (buf != 0xFF) return 3;
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
  if (buf != 0xD8) return 3;

  /* read APP1 Marker */
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
  if (buf != 0xFF) return 4;
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
  if (buf == 0xE0) ret = skipJFIF();
    else if (buf !=0xE1) return 4;
  if (ret) return ret;
 
  /* read size of APP1 data */
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
     memSize = 0x100 * buf; 
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
     memSize += buf; 
     
  /* read Exif Header */
  if (fread(buf4,sizeof(buf),4,f) != 4 ) return 2; 
  if ( strcmp((char*)buf4,"Exif") != 0 ) return 4;

  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
  if (buf != 0x00) return 4;
  if (fread(&buf,sizeof(buf),1,f) != 1 ) return 2;
  if (buf != 0x00) return 4;
  
  return 0;
} 

int readTIFFheader(void) { /* store LE to global variable */

  /* Little Endian or Big Endian */
    
  buf16 = getSHORT(memIndex);
  memIndex += 2;
  if (buf16 == 0x4D4D) 
     LE = 0;
  else if (buf16 != 0x4949) 
     return 3; 
        
  if ( getSHORT(memIndex) != 0x002A ) return 3;
  memIndex += 2;

  /* offset of IFD (if == 8) je hned za tim; */

  memIndex += getLONG(memIndex) - 8;
  memIndex += 4;
  return 0;
}


int readIFD(IFDtype typ) {
  int node, i;       /* number of directory entry */
  unsigned int       tn, df;         /* tag number, data format */
  unsigned long int  coc, di;         /* count of components, data index */

  if ( test(memIndex+2) ) return 7;
  node = getSHORT(memIndex);
  memIndex += 2;

  for (i = 0; i < node; i++) { /* pro kazdou polozku... */
  
    if ( test(memIndex+12) ) return 7;
    getIFD(&tn,&df,&coc,&di);

    /* ladici vypisy
       -------------
       printf("tn: %X\t",tn); 
       printf("df: %X\t",df);
       printf("coc %lu\t",coc);
       printf(" size: %ld\t",coc * dataPcom[df-1]);
       printLONG(getLONG(di));
    */
    
    if (tn == 0x8769) {EXIFoffset = getLONG(di); continue;}
    if (tn == 0x8825) {GPSoffset = getLONG(di); continue;}        
    if (tn == 0xa005) {INTERoffset = getLONG(di); continue;}
    if (tn == 0x927C) {MAKERoffset = getLONG(di); continue;}

    if (printIFDname(tn,typ)) continue;  /* vypis nazvu tagu */
    
    printf(": ");
    
    if ( (coc * dataPcom[df-1]) > 4 ) di = getLONG(di); /* v di offset => nastavim ho */
    if ( test(di) ) return 7;
    if ( printIFDvalue(tn,df,coc,di,decodeval) ) return 7;
    printf("\n");
  }
  return 0;
}


int main(int argc, char *argv[])
{
  int file_index=1;
 
 
/* osetreni vstupu */

  switch (argc) {
    case 1: showHelp();
            return 0;  
            break;       
            
    case 2: if ( !strcmp(argv[1],"-h") || !strcmp(argv[1],"--help") ) {
              showHelp();
              return 0;
            }    
            break;
                 
    case 3: if ( !strcmp(argv[1],"-d") ) {     
              decodeval--;
              file_index++;
            } else return ErrMsg(15);
            break;
            
    default: return ErrMsg(15);
  }
          
/* open file */     

  if ( (f = fopen(argv[file_index],"rb")) == NULL ) return ErrMsg(1);


/* overeni souboru + zjistit velikost  */
 
  err = readAPP1header();
  if (err) { /* chyba - zavru soubor a skoncim */
    if (fclose(f) == EOF) return ErrMsg(10);
    return ErrMsg(err);
  }

/* vyhradit pamet + nacteni do pameti */

  mem = (unsigned char*) malloc(memSize);
  for (i=0; i < memSize; i++) 
      if (fread(&buf,sizeof(buf),1,f) != 1 ) return ErrMsg(5);
      else mem[i] = buf;
  
  memIndex = 0;


/* precist TIFF hlavicku - nastavi LE*/

  err = readTIFFheader();
  if (err) {
    free(mem);
    if (fclose(f) == EOF) return ErrMsg(10);            
    return ErrMsg(err);
  } 

/* cist IFD0 + vypis + ulozeni pointeru na EXIF IFD a GPS IFD */
  
  printf("---======Camera======---\n");
  err = readIFD(tIFD0);
  if (err) {
      free(mem);
      if (fclose(f) == EOF) return ErrMsg(10);            
      return ErrMsg(err);
  }

/* cist dalsi IFD...nahled */

  /* 
  memIndex = getLONG(memIndex);
  err = readIFD(tIFD1);
  if (err) {
    free(mem);
    if (fclose(f) == EOF) return ErrMsg(10);            
    return ErrMsg(err);
  }  
  */

/* cist EXIF IFD if exist */

  if (EXIFoffset != 0) {
    printf("\n---======Image======---\n");                 
    memIndex = EXIFoffset;
    if ( test(memIndex) ) return ErrMsg(7);
    err = readIFD(tEXIF);
    if (err) {
      free(mem);
      if (fclose(f) == EOF) return ErrMsg(10);            
      return ErrMsg(err);
    }
  }
                   
/* uvolnit pamet + uzavrit soubor*/

  free(mem);
  if (fclose(f) == EOF) return ErrMsg(10);
  return 0;
}
