/*
  Name: mem.c
  Copyright: 
  Author: Michal Trs
  Date: May 2005
  Description: implementation of memory
*/

#include "mem.h"

int LE =        1 ;          /* 1 = little endian,     0 = big endian */
unsigned char *mem; 
unsigned long int memIndex;
unsigned long int memSize;
  
/* test end of memory  0=OK, 1=out of memory*/
int test(unsigned long int offset) {
  return (offset > memSize) ?  1 : 0;
}

/* get Byte from memory */
unsigned char getBYTE(unsigned long int adr) {
  return mem[adr];
}

/* get usigned integer (2B) from memory */
unsigned int getSHORT(unsigned long int adr) {

 if (LE) 
    return (mem[adr] + 0x100 * mem[adr+1]);
 else
    return (0x100 * mem[adr] + mem[adr+1]);     
}
 
/* get unsigned integer (4B) from memory */
unsigned long int getLONG(unsigned long int adr) {
 if (LE) 
    return (mem[adr] + 0x100 * mem[adr+1] + 0x10000 * mem[adr+2] + 0x1000000 * mem[adr+3]);
 else
    return (0x1000000 * mem[adr] + 0x10000 * mem[adr+1] + 0x100 * mem[adr+2] + mem[adr+3]);     
}

/* get rational */
double getRATIONAL(unsigned long int adr) {
  return ( (double)getLONG(adr) / (double) getLONG(adr+4));          
}

/* get integer 4B from memory */
long int getSLONG(unsigned long int adr) {
  return getLONG(adr);   
}

/* get signed rational from memory */
double getSRATIONAL(unsigned long int adr) {
  return ((double)getSLONG(adr) / (double)getSLONG(adr+4));          
}
  
