; display.s - funkce pro praci s LCD
; kde je v zasobnik + funkce samozrejme+ulozeni navrat. adresy
; disp_clear - smaze display(mezery),
;		parametry: zadne
; 		meni registry: NIC (zasobnik +4+disp_char nebo 4+delay)
; disp_char - zobrazi ASCII ve w0 na aktualni pozici LCD
;		parametry: w0 - ascii znak
; 		meni registry: NIC (zasobnik +3+delay)
; disp_init - inicializace RF3, RF6 + zpozdeni 1s
;		parametry: zadne
; 		meni registry: NIC (zasobnik +2+delay)
; disp_home - presun kurzoru na 1. radek 1. pozici
;		parametry: zadne
; 		meni registry: NIC (zasobnik +3+disp_char nebo 3+delay)
; disp_str - zobrazi retezec od aktualni pozice po znak #0
;		parametry: w3 - adresa zacatku stringu	
; 		meni registry: NIC (zasobnik +4+disp_char nebo 4+delay)
; disp_pos - presune kurzor na pozici danou w0
;		parametry: w0 - dolni byte-dolni 4bity = pozice v radku(od 0) , horni byte-dolni 1 bit = radek(od 0)
; 		meni registry: NIC (zasobnik +4+disp_char nebo 4+delay)
; disp_num - zobrazeni dekadickeho cisla (-32768..32767) na aktualni pozici
;		parametry:	w2 - cislo k zobrazeni
; 		meni registry: NIC (zasobnik 2+prev_dec nebo 2+disp_str)
; disp_hex - hexadecimalni zobrazeni cisla (0000..FFFF) na aktualni pozici
;		parametry:	w2 - cislo k zobrazeni
; 		meni registry: NIC (zasobnik 2+prev_hex16 nebo 2+disp_str)
; disp_hex32 - hexadecimalni zobrazeni cisla (00000000..FFFFFFFF) na aktualni pozici
;		parametry:	w6:w5 - cislo k zobrazeni
; 		meni registry: NIC (zasobnik 2+prev_hex32 nebo 2+disp_str)



.global disp_clear
.global disp_char
.global disp_init
.global disp_home
.global disp_str
.global disp_pos
.global disp_num
.global disp_hex
.global disp_hex32

disp_clear:
	push SR
	push w0
	push w1
	push w13
	mov #100,w13		; globalni spozdeni 10ms
	mov #0x80, w0		;0x80 presun kurzoru na 0. pozici 1. radku
	call disp_char
	call delay			;zpozdeni mezi posilanim jednotlivych znaku
	call op_mez			; 16x mezera
	mov #0xC0, w0		;0x80 presun kurzoru na 0. pozici 2. radku
	call disp_char
	call delay			;zpozdeni mezi posilanim jednotlivych znaku
	call op_mez			; 16x mezera
	pop w13
	pop w1
	pop w0
	pop SR
	return

op_mez:				;neuklada zadne registry
	mov #16, w1			;16 mezer
	mov #' ', w0
op_mez_loop:
	call disp_char
	call delay		;zpozdeni mezi posilanim jednotlivych znaku
	dec  w1, w1
	bra  NZ, op_mez_loop
	return

disp_char:
	push SR
	push w0
	push w1
	swap w0		;prohodi byty v 16b registru, nizzsi byte je ve vyssim
	mov #8,w1	;pocet posilanych bitu
	bclr LATF,#6	;clk do 0
  opak_send:
	rlc  w0,w0	;do CY nejvyssi bit
	bra NC, nast_0
	bset LATF, #3
	bra  presk_nast1
  nast_0:
	bclr LATF, #3
  presk_nast1:
	bset LATF, #6	;vzest hrana clk
	call delay_100us
	bclr LATF, #6	;sest. hrana clk (precte se RF6)
	call delay_100us
	dec w1,w1
	bra NZ,opak_send
	pop w1
	pop w0
	pop SR
	return

disp_init:
	push SR
	push w13
	mov #10000,w13	; 1 s
	call delay
	bclr TRISF, #3	;RF3
	bclr TRISF, #6	;RF6
	pop w13
	pop SR
	return

disp_home:
	push SR
	push w0
	push w13
	mov #100,w13		; globalni spozdeni 10ms
	mov #0x80, w0		;0x80 presun kurzoru na 0. pozici 1. radku
	call disp_char
	call delay			;zpozdeni mezi posilanim jednotlivych znaku
	pop w13
	pop w0
	pop SR
	return

disp_str:
	push SR
	push w0
	push w3
	push w13
	mov #100,w13		; globalni spozdeni 10ms
  opak_disp_str:
	mov.b [w3],w0		;nacteni znaku
	cp0.b w0			;test na ukonceni
	bra Z, disp_str_end
	call disp_char		;zobrazeni znaku
	call delay			;zpozdeni mezi posilanim jednotlivych znaku
	inc w3, w3			;dalsi znak
	bra opak_disp_str
  disp_str_end:
	pop w13
	pop w3
	pop w0
	pop SR
	return

disp_pos:				;1. radek 0x80..0x8F, 2. radek 0xC0..0xCF
	push SR
	push w0	
	push w1	
	push w13
	mov #100,w13		; globalni spozdeni 10ms
	and.b w0, #0xF, w1	;vyber dolnich 4 bitu
	swap w0				;prohozeni bytu v registru
	and.b #0x1, w0		;zustane nejnizsi bit
	sl w0, #6, w0		;0x80 = 1000 0000, 
	add #0x80, w0		;0xC0 = 1100 0000, 
	add w0, w1, w0		;pricteni pozice v radku
	call disp_char		;poslani operace
	call delay			;zpozdeni mezi posilanim
	pop w13
	pop w1
	pop w0
	pop SR
	return


disp_num:		;je zbytecne push SR
	push w3
	push w4
	mov #vysl, w3		;adresa vysledku
	mov #v_len, w4		;delka vysledku(delka cisla + 1 znak(#0))
	call prev_dec		;prevod s delenim -- ve w3 je adresa cisla
;	call prev_dec1		;prevod bez deleni
	mov #vysl, w3		;adresa vysledku - s mezerama - zarovn. doprava
	call disp_str
	pop w4
	pop w3
	return


disp_hex:		;je zbytecne push SR
	push w3
	push w4
	mov #vysl, w3		;adresa vysledku
	mov #v_len, w4		;delka vysledku(delka cisla + 1 znak(#0))
	call prev_hex16
;	mov #vysl, w3		;adresa vysledku - s '0' na zacatku
	call disp_str
	pop w4
	pop w3
	return


disp_hex32:		;je zbytecne push SR
	push w3
	push w4
	mov #vysl, w3		;adresa vysledku
	mov #v_len, w4		;delka vysledku(delka cisla + 1 znak(#0))
	call prev_hex32
;	mov #vysl, w3		;adresa vysledku - s '0' na zacatku
	call disp_str
	pop w4
	pop w3
	return


	.equ v_len, 5		;delka vysledku s koncovou #0, misto pro 32b cislo
.data
vysl:	.space #v_len	;misto pro prevod - mohlo by byt v conv_dec_hex.s,
						; ale byl by problem se zadavanim delky pro prevod 
						; aby nedostal parametrem vetsi delku, nez ma rezervovanou
