 	.include "p30f4011.inc"
	
	config __FOSC, CSW_FSCM_OFF & XT_PLL4
	config __FWDT, WDT_OFF

  .global __reset
  .global __IC1Interrupt

.text
__reset:
  ; nastaveni zasobniku
    mov #__SP_init,w15
    mov #__SPLIM_init,w0
    mov w0,SPLIM

; pro ladeni
	bclr TRISB, #0
	bclr TRISB, #1
	bset LATB, #0
	bclr LATB, #1

;*******nastaveni Displeje***********
	call disp_init
	call disp_clear
	call disp_home
	mov  #'U', w0
	call disp_char 
	mov  #'=', w0
	call disp_char 

	mov  #0x006,w0
	call disp_pos
	mov  #'m', w0
	call disp_char 
	mov  #'V', w0
	call disp_char 
	mov  #0x100,w0
	call disp_pos
	mov  #'t', w0
	call disp_char 
	mov  #'=', w0
	call disp_char 
	mov  #0x107,w0
	call disp_pos
	mov  #'C', w0
	call disp_char 

;	mov  #0x002,w0
;	call disp_pos


;*******nastaveni AD prevodniku***********
	mov #0xFFF3,w0
	mov w0,ADPCFG 	; // all PORTB = Digital; RB2 = analog
	clr w0
	mov w0, ADCON1	; // SAMP bit = 0 ends sampling ...
	mov w0, ADCSSL
	mov w0, ADCON2;
	mov #0x2,w0
	mov w0,ADCON3	; // Manual Sample, Tad = internal 2 Tcy

;*******mereni napeti***********
	setm w7
	setm w8

start_pot:
	mov #0x2,w0			; vyber RB2 - potenciometr 0-5V
	mov w0,ADCHS	
	bset ADCON1,#ADON	; ADC ON

	bset ADCON1,#SAMP	; start sampling
	mov #1000,w13		; x 100us = 100ms
	call delay 		;
	bclr ADCON1,#SAMP	; start prevodu
conv_pot:
	btst ADCON1,#DONE	
	bra  Z, conv_pot	; jeste neni prevedeno
	mov ADCBUF0,w2		; w2 = vysledek
	
	; provod 0-0x3ff na 0-5000
	mov #640,w3
	mul.uu w2,w3,w0
	mov #131,w4
	repeat #17
	div.ud w0,w4
	mov w0,w2
	cpseq w7,w2
	call vyp_pot
	mov w2,w7
	;call disp_hex	

;*******konec mereni napeti***********


;*******mereni teploty***********
start_temp:
	mov #0x3,w0			; vyber RB3 - teplomer (0.1 - 1.75V = -40C -- 125C)
	mov w0,ADCHS	
	bset ADCON1,#ADON	; ADC ON

	bset ADCON1,#SAMP	; start sampling
	mov #1000,w13		; x 100us = 100ms
	call delay 		;
	bclr ADCON1,#SAMP	; start prevodu
conv_temp:
	btst ADCON1,#DONE	
	bra  Z, conv_temp	; jeste neni prevedeno
	mov ADCBUF0,w2		; w2 = vysledek
	mov #32000, w3
	mul.uu w2,w3,w2
	sub #50,w3		; -40C = 100mV, 10mV/C
	mov w3,w2
	cpseq w8,w2
	call vyp_temp
	mov w2,w8


;*******konec mereni teploty***********

	bra start_pot

	bra .


vyp_temp:
	mov  #0x102,w0
	call disp_pos
	call disp_num
	mov  #0x10F,w0
	call disp_pos
	return


vyp_pot:
	mov  #0x002,w0
	call disp_pos
	call disp_num
	mov  #0x10F,w0
	call disp_pos
	return





menu:	.ascii  "\n\rCopyright 2006-9999 Michal Trs, Milos Hrdy\n\r"

  .bss

