; display.s - funkce pro praci s LCD
; nakodil: Michal trs <trsm1@fel.cvut.cz>
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; disp_init - inicializace RF3, RF6 + zpozdeni 1s
;		parametry: zadne
; 		meni registry: NIC
;
; disp_clear - smaze display (prepise mezerami)
;		parametry: zadne
; 		meni registry: NIC
;
; disp_home - presun kurzoru na 1. radek 1. pozici
;		parametry: zadne
; 		meni registry: NIC
;
; disp_pos - presune kurzor na pozici danou w0
;		parametry: w0 - 0xDDXY, X - radek <0,1>, Y - sloupec <0,15>, DD - don't care
; 		meni registry: NIC
;
; disp_char - zobrazi ASCII ve w0 na aktualni pozici LCD
;		parametry: w0 - ascii znak
; 		meni registry: NIC
;
; disp_str - zobrazi retezec od aktualni pozice po znak #0
;		parametry: w3 - adresa zacatku stringu v pameti	
; 		meni registry: NIC
;
; disp_num - zobrazi cislo v dekadickem formatu
;		parametry: w0  - hodnota cislo
;		meni registry: NIC
;		meni promene: decn
;
; disp_hex - zobrazi 16b cislo (vzdy 4 znaky)
;		parametry: w0  - hodnota cislo
;		meni registry: NIC
;		meni promene: hex16
;
; disp_hex32 - zobrazi 32b cislo (vzdy 8 znaku)
;		parametry: w1:w0  - hodnota cislo
;		meni registry: NIC
;		meni promene: hex32
;


.global disp_init
.global disp_clear
.global disp_home
.global disp_pos
.global disp_char
.global disp_str
.global disp_num
.global disp_hex
.global disp_hex32


disp_init:
	push w13
	mov #10000,w13	; 1s
	call delay
				
	bclr TRISF, #3	;RF3
	bclr TRISF, #6	;RF6
	pop w13
	return


disp_clear:
	push w0
	push w1
	push w13
	mov #100,w13		; globalni spozdeni 10ms
	mov #0x80, w0		;0x80 presun kurzoru na 0. pozici 1. radku
	call disp_char
	call delay			;zpozdeni mezi posilanim jednotlivych znaku
	call op_mez			; 16x mezera
	mov #0xC0, w0		;0x80 presun kurzoru na 0. pozici 2. radku
	call disp_char
	call delay			;zpozdeni mezi posilanim jednotlivych znaku
	call op_mez			; 16x mezera
	pop w13
	pop w1
	pop w0
	return


disp_home:
	push w0
	push w13
	mov #100,w13		; globalni spozdeni 10ms
	mov #0x80, w0		;0x80 presun kurzoru na 0. pozici 1. radku
	call disp_char
	call delay			;zpozdeni mezi posilanim jednotlivych znaku
	pop w13
	pop w0
	return


disp_pos:				;1. radek 0x80..0x8F, 2. radek 0xC0..0xCF
	push w0	
	push w1	
	push w13
	mov #100,w13		; globalni spozdeni 10ms
	mov #0x80,w1		; nastav radek (pozici y)
	btst.z w0,#4		; 5.bit, if 1 then spodni radek
	bra z,set_pos		
	mov #0xC0,w1		; druhy radek	
  set_pos:
	and w0,#0xF,w0		; nastavim pozici x
	add w0,w1,w0		
	call disp_char		;poslani operace
	call delay			;zpozdeni mezi posilanim
	pop w13
	pop w1
	pop w0
	return


disp_char:
	push w0
	push w1
	swap w0		;prohodi byty v 16b registru, nizzsi byte je ve vyssim
	mov #8,w1	;pocet posilanych bitu
	bclr LATF,#6	;clk do 0
  opak_send:
	rlc  w0,w0	;do CARRY nejvyssi bit
	bra NC, nast_0
	bset LATF, #3
	bra  presk_nast1
  nast_0:
	bclr LATF, #3
  presk_nast1:
	bset LATF, #6	;vzest hrana clk
	call delay_100us
	bclr LATF, #6	;sest. hrana clk (precte se RF6)
	call delay_100us
	dec w1,w1
	bra NZ,opak_send
	pop w1
	pop w0
	return


disp_str:
	push w0
	push w3
	push w13
	mov #100,w13		; globalni spozdeni 10ms
  opak_disp_str:
	mov.b [w3],w0		;nacteni znaku
	cp0.b w0				;test na ukonceni
	bra Z, disp_str_end
	call disp_char		;zobrazeni znaku
	call delay			;zpozdeni mezi posilanim jednotlivych znaku
	inc w3, w3			;dalsi znak
	bra opak_disp_str
  disp_str_end:
	pop w13
	pop w3
	pop w0
	return


disp_num:
	push w3
	call conv_num	; prevede w0  --> decn
	mov #decn,w3
	call disp_str
	pop w3
	return


disp_hex:
	push w3
	call conv_hex16	; prevede w0  --> hex16
	mov #hex16,w3
	call disp_str
	pop w3
	return


disp_hex32:
	push w3
	call conv_hex32	; prevede w0  --> hex32
	mov #hex32,w3
	call disp_str
	pop w3
	return


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; pomocne procedury
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

conv_num:      		; dec cislo v rozsahu -32768, 32767
	push w0
	push w1
	push w2
	push w5
	push w10
	push w12
	mov #10,w10		; timhle delim
	mov #decn,w5 	; w5 - adresa kam ukladam
	clr w2			; citac
	mov w0,w12		; w12 - cislo ktere prevadim	

	btst.z w0,#15	; test jesli je cislo zaporne
	bra z,dec_loop	; zaporne?
	neg w0,w12		; => prevedu na kladne
	mov #0x2d,w1	; '-'
	mov.b w1,[w5]
	inc w5,w5

  dec_loop:
	repeat #17
	div.u w12,w10	; vysl ve w0, zbytek w1
	add #0x30,w1	; -> ascii
	inc w2,w2		
	push w1			; zbytek = cislo ulozim na zasobnik
	mov w0,w12		; mezivysledek => cislo k vydeleni
	cp0 w12
	bra z,dec_end	; cislo je 0 -> konec deleni
	bra dec_loop

  dec_end: 			; prevraceni cisla ze zasobniku do promeny
	pop w1
	mov.b w1,[w5++]
	dec w2,w2
	bra nz,dec_end
	
	mov #0x0,w1
	mov.b w1,[w5] ; ukoncim retezec nulou 

	pop w12
	pop w10
	pop w5
	pop w2
	pop w1
	pop w0
   	return
   
   
conv_hex16:      		; 16bit hex cislo
	push w2
	push w1
	mov #hex16,w2	; adresa retezce
	mov #0,w1
	mov.b w1,[w2+4]	; ukonceni retezce 0
	call hextoascii
	pop w1
	pop w2
	return
   
   
conv_hex32:    ; 32bit hex cislo
	push w0
	push w2
	push w3
	mov #hex32,w2	; adresa retezce
	mov #0,w3
	mov.b w3,[w2+8]	; ukonceni retezce 0
	add #4,w2
	call hextoascii
	sub w2,#4
	mov w1,w0
	call hextoascii
	pop w3
	pop w2
	pop w0
	return  	


op_mez:					;neuklada zadne registry
	mov #16, w1			;16 mezer
	mov #' ', w0
  op_mez_loop:
	call disp_char
	call delay		;zpozdeni mezi posilanim jednotlivych znaku
	dec  w1, w1
	bra  NZ, op_mez_loop
	return


hextoascii:	; w0 - 16b hex cislo, w2 - promenna v pameti
	push w0
	push w1	
	push w3
	push w4

	mov #0x3a,w4	; pro porovnani zda cislo nebo a-f
	mov #4,w3		; counter 4 x 4b

  htoa_loop: and w0,#0xF,w1
	add #0x30,w1	; posun do ASCII - prictu '0'
	cpslt.b w1,w4	; pokud je cislo preskoc
	add #7,w1		; v ASCII mezi 9 a A rozdil 7 => musim jeste 1 pricist
	
	dec w3,w3		; posun kvuli adresovani
	mov.b w1,[w2+w3]; ulozeni znaku do pameti
	inc w3,w3
	lsr w0,#4,w0	; posun na dalsi znak ve w0 
	dec w3,w3		; posun na dalsi znak + snizim counter
	bra nz,htoa_loop
	
	pop w4
	pop w3
	pop w1
	pop w0
	return

	

.data ; promenne s vysledkem: max delka stringu + 0x0
	decn:    .space 7		
	hex16:   .space 5 	
	hex32:   .space 9	

