; conv_dec_hex.s prevody do desitkove a hexadecimalni soustavy

; prev_hex32 - pro 32b prevod na hexa (00000000..FFFFFFFF), zakonceni #0
;		parametry:	w6:w5 - 32b cislo k prevodu
;					w3 - adresa mista pro vysledek
;					w4 - delka mista pro vysledek (pokud je delsi nez cislo je vyplneno '0')
;		meni: NIC (zasobnik +8)
; prev_hex16 - pro 16b prevod na hexa (0000..FFFF), zakonceni #0
;		parametry:	w2 - 16b cislo k prevodu
;					w3 - adresa mista pro vysledek
;					w4 - delka mista pro vysledek (pokud je delsi nez cislo je vyplneno '0')
;		meni: NIC (zasobnik +6)
; prev_dec - pro 16b prevod na dec delenim (-32768..32767), zakonceni #0
;		parametry:	w2 - 16b cislo k prevodu
;					w3 - adresa mista pro vysledek
;					w4 - delka mista pro vysledek (pokud je delsi nez cislo je vyplneno ' ')
;		meni: NIC (zasobnik +8)
;		vystupni parametry:
;					w3 - prvni znak ruzny od ' ', tj. '-' nebo 1. cislice
; prev_dec1 - pro 16b prevod na dec bez deleni (-32768..32767), zakonceni #0
;		parametry:	w2 - 16b cislo k prevodu
;					w3 - adresa mista pro vysledek
;					w4 - delka mista pro vysledek (pokud je delsi nez cislo je vyplneno ' ')
;		meni: NIC (zasobnik +10)


.global prev_hex32
.global prev_hex16
.global prev_dec
.global prev_dec1

;podprogram pro prevod do dekad. soust. pracuje s w0,w1,w2,w4,vysledek na adr ve [w3]+w4
;nekontroluje, zda se prevedene cislo vejde do delky ve w4, vysledek je zarovnan na konec mista
;w6:w5: cislo k prevodu
;w3: adresa vysledku
;w4: delka stringu
prev_hex32:			;pro 32b prevod na hexa (00000000..FFFFFFFF)
	push SR
	push w0
	push w1
	push w2
	push w3
	push w4
	push w5
	push w6
;	mov #vysl, w3	;adresa vysledku, pro delkaraci v tomto souboru
	dec w4,w4		;aby pak uk. na posl. index
	add w3, w4, w3	;posl. index
	mov.b #0, w0	;zakonceni stringu nulou
	mov.b w0,[w3]
	mov #tbloffset(c1),w1			;pocatek pole konstant pro prevod
neni_z_hex32:
;	dec w3,w3		;presun o 1 znak dopredu
	and w5,#0xf,w0	;ziskani nejniz. 4 bitu
	add w0,w1,w0	;vypocet mista v poli
	tblrdl.b [w0],w0	;nacteni znaku
	mov.b w0, [--w3]	;presun znaku na vysledne misto
	lsr w5,#4,w5	;posun o 4 bity
	and w6,#0xf,w2	;do w2 4 nejniz. bity z w6 (vyssich 16b)
	lsr w6,#4,w6	;posun o 4 bity
	sl w2,#12,w2	;dostat 4 bity do nejvyssich 4 bitu
	ior w2,w5,w5	;pridat k w5
	dec w4,w4		;projde celou delku - na zacatku budou nuly
	bra NZ, neni_z_hex32
	pop w6
	pop w5
	pop w4
	pop w3
	pop w2
	pop w1
	pop w0
	pop SR
	return

;podprogram pro prevod do dekad. soust. pracuje s w0,w1,w2,w4,vysledek na adr ve [w3]+w4
;nekontroluje, zda se prevedene cislo vejde do delky ve w4, vysledek je zarovnan na konec mista
;w2: cislo k prevodu
;w3: adresa vysledku
;w4: delka stringu
prev_hex16:			;pro 16b prevod na hexa (0000..FFFF)
	push SR
	push w0			;push.s,pop.s - jen w0-w3
	push w1
	push w2
	push w3
	push w4
;	mov #vysl, w3	;adresa vysledku, pro delkaraci v tomto souboru
	dec w4, w4
	add w3, w4, w3
	mov.b #0, w0	;zakonceni stringu nulou
	mov.b w0,[w3]
	mov #tbloffset(c1),w1			;pocatek pole konstant pro prevod
neni_z_hex16:
;	dec w3,w3		;presun o 1 znak dopredu
	and w2,#0xf,w0	;ziskani nejniz. 4 bitu
	add w0,w1,w0	;vypocet mista v poli
	tblrdl.b [w0],w0	;nacteni znaku
	mov.b w0, [--w3]	;presun znaku na vysledne misto
	lsr w2,#4,w2	;posun o 4 bity
	dec w4,w4		;projde celou delku - na zacatku budou nuly
	bra NZ, neni_z_hex16
	pop w4
	pop w3
	pop w2
	pop w1
	pop w0
	pop SR
	return


;podprogram pro prevod do dekad. soust. pracuje s w0,w1,w2,w4,w5,vysledek na adr ve [w3]+w4
;nekontroluje, zda se prevedene cislo vejde do delky ve w4, vysledek je zarovnan na konec mista
;w2: cislo k prevodu
;w3: adresa vysledku
;w4: delka stringu
;navrat: w3: adresa 1. platneho znaku
prev_dec:			;pro prevod do dekadicke soustavy(-32768..32767)
	push SR
	push w0			;push.s,pop.s - jen w0-w3
	push w1
	push w2
;	push w3			; ve w3 se vraci kde zacina vysledek
	push w4
	push w5
;	mov #vysl, w3	;adresa vysledku, pro deklaraci v tomto souboru
	mov #10, w5		;delitel
;vymezerovani mista	
	mov.b #' ', w0
	dec w4, w4
	repeat w4
	mov.b w0,[w3++]
	dec w3, w3		; aby uk. na posl pozici
	push w3			; pro ulozeni #0 na konci
	btst.C w2, #15	;nastavi Carry podle nejv. bitu
	bra NC, neni_z_dec	;neni zaporne
	neg w2,w2
	mov.b #'-', w0	;minus na posl. miste - pak se prepise #0(konec stringu)
	mov.b w0,[w3]
neni_z_dec:
;	dec w3,w3		;presun o 1 znak dopredu
	repeat #17
	div.u w2, w5	;unsigned deleni w2/w4, vysledek ve w0, zbytek ve w1
	mov w0, w2		;vysledek zpet do w2
	add #'0',w1		;prevod zbytku na znak
	mov.b w1, [--w3]	;presun znaku na vysledne misto
	cp0 w2			;pokud je 0, tak se skonci
	bra NZ, neni_z_dec

;	dec w3, w2		; sem se ulozi pripadne znamenko (jinak mezera)
;	pop w3			;zde je pripadne znamenko
	pop w2			;zde je pripadne znamenko
;	mov.b [w3],[w2]
	mov.b [w2], w0	;pro porovnavani
	sub.b w0, #' '
	bra Z, neni_mmm			; je to mezera - nepresouva se '-'
	mov.b [w2],[--w3]		; je tam znamenko - presun na zacatek
neni_mmm:
	mov.b #0, w0	;zakonceni stringu nulou
;	mov.b w0,[w3]
	mov.b w0,[w2]
	pop w5
	pop w4
;	pop w3
	pop w2
	pop w1
	pop w0
	pop SR
	return


;podprogram pro prevod do dekad. soust. pracuje s w0,w1,w2,w4,w5,vysledek na adr ve [w3]+w4
;nekontroluje, zda se prevedene cislo vejde do delky ve w4, vysledek je zarovnan na konec mista
;w2: cislo k prevodu
;w3: adresa vysledku
;w4: delka stringu
; vystup: w3 navrat adresa vysledku bez ' '
prev_dec1:			;pro prevod do dekadicke soustavy(-32768..32767)
	push SR
	push w0			;push.s,pop.s - jen w0-w3
	push w1
	push w2
;	push w3			; w3 navrat adresa vysledku bez ' '
	push w4
	push w5
	push w6
;	mov #vysl, w3	;adresa vysledku, pro deklaraci v tomto souboru
;vymezerovani mista	
	dec w4, w4			;aby uk. na posl. index
	mov.b #' ', w0
	repeat w4		; vezme bity <13:0> z w4 + 1
	mov.b w0,[w3++]

	dec w3, w3
	push w3				; pro ulozeni indexu #0 na konci a presun pripadneho znamenka

;	mov.b #' ', w0		;mezera -- if zaporne, zmeni se na '-', ve w0 je jeste ' '
	btst.C w2, #15		;nastavi Carry podle nejv. bitu
	bra NC, neni_z_dec1	;neni zaporne
	neg w2,w2
	mov.b #'-', w0		;minus na posl. miste - pak se prepise #0(konec stringu)
neni_z_dec1:
	mov.b w0,[w3--]
	mov #mezivysl, w6	; pocatek mezivysledku, vynulovani pomocneho mista
	clr w1
	repeat #del_konst-1	; provede del_konst-1+1
	mov.b w1, [w6++]	;vynulovani mista

;	mov #tblpage(cBCD), w1			;pocatek pole konstant pro prevod
;	mov w1, TBLPAG
	mov #tbloffset(cBCD), w1			;pocatek pole konstant pro prevod
	push w3
	clr w3
neni_z_addBCD:
	lsr w2, w2			; posun o 1 bit doprava do carry
	bra NC, nescitej	; nebyla "1"
	mov #mezivysl, w6	; pocatek mezivysledku
	mov #del_konst, w5	; pocet bytu, pro ktere se bude opakovat
;	bclr SR, #0			; snulovat carry - aby neovlivnil addc
	clr w4
opak_scitB:
	tblrdl.b [w1++], w0	;nacteni konstanty
	add.b w4, [w6], w4	;nacteni 1 Bytu mezivysledku a pricteni k w4
	addc.b w4, w0, w0	;secteni
	daw.b w0			;decimal adjust po souctu 2 bytu v BCD
	mov SR, w4
	cp  w4, #4			;je jen OV
	bra NZ, neni_vyjim
	bset w4, #0			;vytvoreni carry
neni_vyjim:
	mov w4, SR
	addc.b  w3, #0, w4		;ulozeni carry do w4 (w3=0)
	mov.b w0, [w6++]	;ulozeni vysledku
	dec w5, w5			;nastavuje carry
	bra NZ, opak_scitB
	bra presk_add3
nescitej:
	add w1, #del_konst, w1	; posun na dalsi mocninu 2
presk_add3:
	cp0 w2				;pokud je 0, tak se skonci
	bra NZ, neni_z_addBCD

	;prevod na string a ulozeni na misto dane registrem w3
	pop w3
	mov #mezivysl, w6	;nejniz. byte mezivysledku
	mov #del_konst, w5
opak_BCDstr:			
	mov.b [w6++], w0	;nacteni
	and #0xFF, w0		;nizsi Byte 
	and w0, #0xF, w1	;nizsi 4 bity 
	add #'0', w1		;prevod na znak
	mov.b w1, [w3--]	;presun znaku na vysledne misto
	lsr w0, #4, w1		;vyssi 4 bity
	add #'0', w1		;prevod na znak
	mov.b w1, [w3--]	;presun znaku na vysledne misto
	dec w5, w5
	bra NZ, opak_BCDstr

	;odstraneni "0" na zacatku a presun znamenka
	mov #' ', w1
opak_hled:
	mov.b [++w3], w0
	sub #'0', w0		;cp w0, #'0' nejde je jen pro #lit5
	bra NZ, ukon_hled	; skonci na cisle nebo ' ', '-'
	mov.b w1, [w3]
	bra opak_hled
 
ukon_hled:
	pop w2			;zde je pripadne znamenko
	cp  w3, w2		; zda uk na stej. adresu
	bra NZ, nebyla_nula
	mov #'0', w1	; vysledkem byla 0
	mov.b w1, [w3]	; w3 uk. na cislici
nebyla_nula:
	mov.b [w2], w0	;pro porovnavani s ' '
	sub.b w0, #' '	;nejde cp w0, #' '
	bra Z, nebylo_znnn	; je to mezera - nepresouva se '-'
	mov.b [w2],[--w3]		; sem se ulozi pripadne znamenko (jinak mezera)
nebylo_znnn:
	mov.b #0, w0	;zakonceni stringu nulou
	mov.b w0,[w2]
	pop w6
	pop w5
	pop w4
;	pop w3
	pop w2
	pop w1
	pop w0
	pop SR
	return


c1:	.byte '0'		;konstanty pro prevod do hex stringu
	.byte '1'		
	.byte '2'		
	.byte '3'		
	.byte '4'		
	.byte '5'		
	.byte '6'		
	.byte '7'		
	.byte '8'		
	.byte '9'		
	.byte 'A'		
	.byte 'B'		
	.byte 'C'		
	.byte 'D'		
	.byte 'E'		
	.byte 'F'		

	.equ  del_konst, 3
cBCD:				; konstanty pro prevod do dec. stringu, 1 cislo dlouhe "del_konst"
	.byte 0x01			; pro 1 v BCD
	.byte 0x00
	.byte 0x00

	.byte 0x02			; pro 2 v BCD
	.byte 0x00
	.byte 0x00

	.byte 0x04			; pro 4 v BCD
	.byte 0x00
	.byte 0x00

	.byte 0x08			; pro 8 v BCD
	.byte 0x00
	.byte 0x00

	.byte 0x16			; pro 16 v BCD
	.byte 0x00
	.byte 0x00

	.byte 0x32			; pro 32 v BCD
	.byte 0x00
	.byte 0x00

	.byte 0x64			; pro 64 v BCD
	.byte 0x00
	.byte 0x00

	.byte 0x28			; pro 128 v BCD
	.byte 0x01
	.byte 0x00

	.byte 0x56			; pro 256 v BCD
	.byte 0x02
	.byte 0x00

	.byte 0x12			; pro 512 v BCD
	.byte 0x05
	.byte 0x00

	.byte 0x24			; pro 1024 v BCD
	.byte 0x10
	.byte 0x00

	.byte 0x48			; pro 2048 v BCD
	.byte 0x20
	.byte 0x00

	.byte 0x96			; pro 4096 v BCD
	.byte 0x40
	.byte 0x00

	.byte 0x92			; pro 8192 v BCD
	.byte 0x81
	.byte 0x00

	.byte 0x84			; pro 16384 v BCD
	.byte 0x63
	.byte 0x01

	.byte 0x68			; pro 32768 v BCD
	.byte 0x27
	.byte 0x03


;	.equ v_len, 9		;delka vysledku s koncovou #0, misto pro 32b cislo

	.data				;datovy segment pro promenne
mezivysl:
;	.align 2			;zarovnani na sodou adresu
	.space #del_konst	;misto pro prevod do BCD, nemsi byt zarovnane na sodou adresu -- cte se i zapisuje po 1 Bytu
;	.align 2			;zarovnani na sodou adresu
