 	.include "p30f4011.inc"
	
	config __FOSC, CSW_FSCM_OFF & XT_PLL4
	config __FWDT, WDT_OFF

  .global __reset
  .global __IC1Interrupt

.text
__reset:
  ; nastaveni zasobniku
    mov #__SP_init,w15
    mov #__SPLIM_init,w0
    mov w0,SPLIM

; pro ladeni
	bclr TRISB, #0
	bclr TRISB, #1
	bset LATB, #0
	bclr LATB, #1

;RE8 S5 PORTE.8
;RD0 S6 PORTD.0
	bset TRISE, #8	;nastaveni pro cteni portu
	bset TRISD, #0
	

	mov #47, w0			;vypoctena hodnota -1
	mov w0, U1BRG		; nast. rychlosti 7,3728 MHz/(16*U1BRG)
	mov #0x8400,w0
	mov w0, U1MODE		;typ prenosu - bez parity, 1 stop, 8bit
	mov #0x0400,w0
	mov w0, U1STA		;transmit enable

	clr w10
	call vyp_menu
 
op_nacticmd:
	call vyp_cmd
	call nacti_cmd		;vrati cislo 0-4 ve w1
	cp0 w1
	bra NZ,test_1
	btg LATB, #0		;zneguj LED1
	bra op_nacticmd
test_1:
	dec w1,w1		;nastavi ZERO flag
	bra NZ,test_2
	btg LATB, #1		;zneguj LED2
	bra op_nacticmd
test_2:  
	dec w1,w1
	bra NZ,test_3

 opak_tst_tl0:
	mov  PORTE, w0
	and  #0x100,w0
	call delay_100us
	mov  PORTE, w2
	and  #0x100,w2
	cp w2,w0
	bra NZ, opak_tst_tl0
	cp0  w0

	bra  Z, posli_tl0_0		; same 0 - min 8 testu tlacitka
	call  vyp_tl0_1 
	bra op_nacticmd
 posli_tl0_0:
	call  vyp_tl0_0 
	bra op_nacticmd
test_3:
	dec w1,w1
	bra NZ,test_4
 opak_tst_tl1:
	mov  PORTD, w0
	and  #0x1,w0
	call delay_100us
	mov  PORTD, w2
	and  #0x1,w2
	cp w2,w0
	bra NZ, opak_tst_tl1
	cp0  w0

	bra  Z, posli_tl1_0		; 0 = stisknuto
	call  vyp_tl1_1 
	bra op_nacticmd
 posli_tl1_0:
	call  vyp_tl1_0 
	bra op_nacticmd
test_4:		;posledni moznost
	call vyp_menu
	bra  op_nacticmd
	bra .


vyp_tl0_0:		;vypise TL1 stisknuto
	push w10
	mov #tl0_st-#menu, w10	; 0 = stisknuto
	call vyp_menu
 	pop w10
	return
vyp_tl1_0:		;vypise TL2 stisknuto
	push w10
	mov #tl1_st-#menu, w10	; 0 = stisknuto
	call vyp_menu
 	pop w10
	return
vyp_tl0_1:		;vypise TL1 Nestisknuto
	push w10
	mov #tl0_nst-#menu, w10	; 1 = nestisknuto
	call vyp_menu
 	pop w10
	return
vyp_tl1_1:		;vypise TL2 Nestisknuto
	push w10
	mov #tl1_nst-#menu, w10	; 1 = nestisknuto
	call vyp_menu
 	pop w10
	return

vyp_rtfm:		;vypise RTFM
	push w10
	mov #rtfm-#menu, w10
	call vyp_menu
 	pop w10
	return


vyp_cmd:
	push w10
	mov #cmd-#menu, w10
	call vyp_menu
 	pop w10
	return


nacti_cmd:				;blokujici cekani na klavesu(prikaz)
	push w0				; ve w1 je zadany prikaz
	push w12
	mov #psvpage(cmds), w12	;do pameti dat se mapuji 32K stranky
	mov w12, PSVPAG			;nastavi stranku
	bset.b CORCON, #PSV
	mov #psvoffset(cmds), w12	
	push w12
 prazdny_prijemcmd:
	mov U1STA, w0
	btst.Z w0, #URXDA
	bra Z, prazdny_prijemcmd
	mov U1RXREG, w1
	pop w12				;nacteni a ulozeni ofsetu
	push w12	
opak_tstcmd:
	mov.b [w12++], w0
	cp0.b w0
	bra NZ, jeste_nekon_cmd
	call vyp_rtfm
	call vyp_cmd
	bra prazdny_prijemcmd
 jeste_nekon_cmd:
	cp.b w0,w1
	bra NZ,opak_tstcmd

 plny_vysilcmd:
	mov U1STA, w0
	btst.Z w0, #UTXBF
	bra NZ, plny_vysilcmd
	mov w1, U1TXREG
 konec_cmd:
	dec w12, w12 ;uk. na dalsi znak
	pop w0			;offset
	sub w12,w0,w12
	lsr w12,#1,w1
	pop w12
	pop w0
	return



vyp_menu:
	push w0
	push w1
	push w12
	mov #psvpage(menu), w12	;do pameti dat se mapuji 32K stranky
	mov w12, PSVPAG			;nastavi stranku
	bset.b CORCON, #PSV
	mov #psvoffset(menu), w12
	add w12,w10,w12
dalsi_znm:

	mov.b [w12++], w1 
	cp0 w1
	bra Z, konec_vypm
plny_vysil:
	mov U1STA, w0
	btst.Z w0, #UTXBF
	bra NZ, plny_vysil
	mov w1, U1TXREG
	bra dalsi_znm
 konec_vypm:
	pop w12
	pop w1
	pop w0
	return


menu:	.ascii  "\n\rCopyright 2006-9999 Michal Trs, Milos Hrdy\n\r"
		.ascii  "MENU:\n\r"
      	.ascii  "  A - zneguj LED1\n\r"
      	.ascii  "  B - zneguj LED2\n\r"
      	.ascii  "  C - Stav TL1\n\r"
      	.ascii  "  D - Stav TL2\n\r"
      	.ascii  "  H - Help\n\r\0"
cmd:  	.ascii  "\n\rcmd>\0"
cmds: 	.ascii  "AaBbCcDdHh\0"
tl0_st: .ascii  "\n\rStisknuto TL1\n\r\0"
tl1_st: .ascii  "\n\rStisknuto TL2\n\r\0"
tl0_nst:.ascii  "\n\rNestisknuto TL1\n\r\0"
tl1_nst:.ascii  "\n\rNestisknuto TL2\n\r\0"
rtfm:	.ascii  "\n\rRTFM\n\r\0"


  .bss

