unit zasobnik;

interface

// Zasobnik pomoci spojoveho seznamu.

type TUserType=Char;
const EmptyUserType=' ';

type
 PPrvek=^TPrvek;
 TPrvek=record
  Data:TUserType;
  Dalsi:PPrvek;
 end;

 TZasobnik=class(TObject)
  private
   Vrchol:PPrvek;
  public
   function Cti:TUserType;
   procedure Vloz(const New:TUserType); // Push
   function Prazdny:Boolean;
   function Zrus:Boolean; // Zrusi prvek na vrcholu.
   function Pop:TUserType;
   constructor Create;
   destructor Destroy; override;
 end;


implementation


{ TZasobnik }

constructor TZasobnik.Create;
begin
inherited Create;
Vrchol:=nil;
end;

function TZasobnik.Cti: TUserType;
begin
if Vrchol=nil then Result:=EmptyUserType
else Result:=Vrchol.Data;
end;

destructor TZasobnik.Destroy;
begin
while (not Prazdny)do Zrus; // Vyprazdeni zasobniku.
inherited Destroy;
end;

function TZasobnik.Pop: TUserType;
begin
Result:=Cti;
Zrus;
end;

function TZasobnik.Prazdny: Boolean;
begin
Result:=(Vrchol=nil);
end;

procedure TZasobnik.Vloz(const New: TUserType);
var p:PPrvek;
begin
System.New(p); // Vytvoreni noveho prvku.
p^.Data:=New; // Prirazeni dat.
p^.Dalsi:=Vrchol; // Zapojeni do seznamu.
Vrchol:=p;
end;

function TZasobnik.Zrus:Boolean;
var p:PPrvek;
begin
Result:=not Prazdny;
if Result then
 begin
  p:=Vrchol;
  Vrchol:=Vrchol.Dalsi; // Vrcholem se stane prvek o patro nize.
  Dispose(p);
 end;
end;

end.
