-- Michal Trs, trsm1@fel.cvut.cz

-- Write a VHDL testbench entity MULT_TEST to test the multiplier function.

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
use ieee.std_logic_arith.all; 

entity MULT_TEST is
end MULT_TEST;

architecture MULT_TEST_BODY of MULT_TEST is

   component MULT
   port(
      CLK   : in std_logic;
      ARES  : in std_logic;
      START : in std_logic;
      DATA  : inout std_logic_vector(7 downto 0);
      READY : out std_logic );
   end component;

   signal clk  : std_logic := '0';
   signal ares : std_logic := '0';
   signal start: std_logic := '0';
   signal data : std_logic_vector(7 downto 0);
   signal ready: std_logic;
   
   signal res_low   : std_logic_vector(7 downto 0);

   constant T : time := 20 ns;

begin

   uut: MULT port map(clk, ares, start, data, ready);

   clk <= not clk after T/2;

   test: process
   begin
      -- as_reset
      ares <= '1';
      wait for 3*T;
      ares <= '0';
      wait for 3*T;

      -- test vector 1
      wait until clk = '1' and clk'event;
      data <= conv_std_logic_vector(6, 8);      
      start <= '1';
      wait until clk = '1' and clk'event;
      start <= '0';
      data <= conv_std_logic_vector(8, 8);
      wait until clk = '1' and clk'event;
      data <= (others => 'Z');
      
      wait until ready = '1';
      res_low <= data;
      wait until clk = '1' and clk'event;
      
      assert data & res_low = 6 * 8
         report "chyba nasobeni 6 * 8"
         severity failure;

     wait for 5*T;

      wait until clk = '1' and clk'event;

      -- test vector 2
      wait until clk = '1' and clk'event;
      data <= conv_std_logic_vector(25, 8);      
      start <= '1';
      wait until clk = '1' and clk'event;
      start <= '0';
      data <= conv_std_logic_vector(119, 8);
      wait until clk = '1' and clk'event;
      data <= (others => 'Z');
      
      wait until ready = '1';
      res_low <= data;
      wait until clk = '1' and clk'event;
      
      assert data & res_low = 25 * 119
         report "chyba nasobeni 25 * 119"
         severity failure;

     wait for 5*T;




      wait;
   end process;

   
end MULT_TEST_BODY;
