-- Michal Trs, trsm1@fel.cvut.cz

-- The register is a synchronous sequential circuit that has 4 inputs and 1 output.
-- Data input: 8-bit data input I.
-- Control inputs: clock CLK, clock enable CE (=load), synchronous reset RST.
-- Output: 8-bit data output O.
-- 
-- The reset signal (RST) has higher priority than the load signal (CE). All inputs are synchronous to the clock signal (CLK).
-- 
-- Implement the register using 1 process.
--
-- Write a VHDL entity REG implementing the register.

library IEEE;
use ieee.std_logic_1164.all;

entity REG is
 port(
   I:    in   std_logic_vector(7 downto 0);
   CLK:  in   std_logic;
   CE:   in   std_logic;
   RST:  in   std_logic;
   O:    out  std_logic_vector(7 downto 0)
 );
end REG;

architecture REG_BODY of REG is
begin
    
    reg: process(CLK, RST, CE)
    begin
       if CLK = '1' and CLK'event then
          if RST = '1' then
              O <= (others => '0');
          elsif CE = '1' then
              O <= I;
          end if;           
       end if;    
    end process;
    
end REG_BODY;