-- Michal Trs, trsm1@fel.cvut.cz

-- The 8-bit shifter has 4 ports:
-- Inputs: one 8-bit vector I , one 1-bit signal SI (shift in)
-- Ouptuts: one 8-bit vector O, one 1-bit signal SO (shift out)
-- 
-- Implement the shifter as wires.
-- 
-- Hint: use array slices, e.g. A(1 to 4), B(7 downto 1)
-- Hint: use concatenation operator &, e.g. '1' & '0' & "001" = "10001"
--
-- Write a VHDL entity describing the shifter.

library ieee; 
use ieee.std_logic_1164.all;

entity SHIFTER is
  port (
    SI: in std_logic;
    I : in std_logic_vector(7 downto 0);
    O : out std_logic_vector(7 downto 0);
    SO: out std_logic
  );
end SHIFTER;


architecture SHIFTER_BODY of SHIFTER is    
begin
   SO <= I(0);
   O  <= SI & I(7 downto 1);    
end SHIFTER_BODY;
