/*************************************/
/* Tomas Lusk, Michal Simek (C) 2005 */
/*************************************/

#ifndef _PRINTLIB_H_
#define _PRINTLIB_H_

#include <string>


typedef unsigned long long int64;


// abstract output class
struct Writer
{
  // write text to output
  virtual void Write(const std::string &text) = 0;
  // returns window width
  virtual int Width() = 0;
};


// abstract formating class
class Printer
{
protected:
  int64 *dat;
  std::string def_format;
public:
  Printer() : dat(0), def_format("%8s: %8s") {} // max "%10s: %8s"
  // init with new data
  virtual void Set(int64 data[]) { dat = data; }
  // write formated data to output
  virtual void Write(Writer &output) = 0;
};


// item for PrinterFactory
#define PFI(mode, class) case (mode): { Printer *p = new class; p->Set(data); return p; } break;


#endif
