/*************************************/
/* Tomas Lusk, Michal Simek (C) 2005 */
/*************************************/

#include <stdio.h>
#include <string>

using namespace std;

void Print(const string &text, int val = 0, bool ind = true)
{  
  string tt = text + "\n";
  if(ind) tt = "\t" + tt;
  printf(tt.c_str(), val);
}

void Print2(const string &text, int val = 0, int val2 = 0, bool ind = true)
{  
  string tt = text + "\n";
  if(ind) tt = "\t" + tt;
  printf(tt.c_str(), val, val2);
}

void Com(const string &text, int val = 0, bool ind = true)
{  Print("# "+text,val, ind); }
void ComM(const string &text, int val = 0, bool ind = false)
{  Print("# "+text,val, ind); }
void Macro(const string &text, int val = 0)
{  Print(".macro "+text,val, false); }
void Endm()
{  Print(".endm",0,false); }
void Ins(const string &text, int val = 0)
{  Print(text,val,true); }
void NLNL()
{ Print("\n\n",0,false); }

//////////////////////////////////////////////////////////////////

// PRINT_Rxx
void Rone(int i)
{
    ComM("print r%d register",i);
    Macro("PRINT_R%d",i);
    Ins("_PUSHA");
    if(i == 12) Ins("_SGR_R12 0");
    else if(i == 14) Ins("_SGR_R14 0");
    else Ins("_SGR r%d",i);
    Ins("_SNUM %d",i);
    Ins("_SNUM 4");
    Ins("_ASP -8");
    Ins("_CALL print_arraySP#");
    Ins("_ASP 4*8");
    Ins("_POPA");
    Endm();
    NLNL();
}

// PRINT_GRx
void GRset(int idx, int start, int count)
{
    Print2("# print r%d-r%d",start,start+count-1,false);
    Macro("PRINT_GR%d",idx);
    Ins("_PUSHA");
    for(int i = start+count-1; i >= start; i--)
    {
      if(i == 12) Ins("_SGR_R12 (%d*8)",start+count-1 - i);
      else if(i == 14) Ins("_SGR_R14 (%d*8)",start+count-1 - i);
      else Ins("_SGR r%d",i);
    }
    Ins("_SNUM %d",idx);
    Ins("_ASP -8");
    Ins("_CALL print_arraySP#");
    Ins("_ASP 34*8");
    Ins("_POPA");
    Endm();
    NLNL();
}


// PRINT_Fxx_E
void FoneE(int i)
{
    ComM("print f%d register - extended precision",i);
    Macro("PRINT_F%d_E",i);
    Ins("_PUSHA");
    Ins("_SFR_E f%d",i);
    Ins("_SNUM %d",i);
    Ins("_SNUM 7");
    Ins("_ASP -8");
    Ins("_CALL print_arraySP#");
    Ins("_ASP 4*8");
    Ins("_POPA");
    Endm();
    NLNL();
}


// PRINT_Fxx_D
void FoneD(int i)
{
    ComM("print f%d register - double precision",i);
    Macro("PRINT_F%d_D",i);
    Ins("_PUSHA");
    Ins("_SFR_D f%d",i);
    Ins("_SNUM %d",i);
    Ins("_SNUM 6");
    Ins("_ASP -8");
    Ins("_CALL print_arraySP#");
    Ins("_ASP 4*8");
    Ins("_POPA");
    Endm();
    NLNL();
}

// PRINT_Fxx_S
void FoneS(int i)
{
    ComM("print f%d register - single precision",i);
    Macro("PRINT_F%d_S",i);
    Ins("_PUSHA");
    Ins("_SFR_S f%d",i);
    Ins("_SNUM %d",i);
    Ins("_SNUM 5");
    Ins("_ASP -8");
    Ins("_CALL print_arraySP#");
    Ins("_ASP 4*8");
    Ins("_POPA");
    Endm();
    NLNL();
}



int main()
{
  printf("#*************************************#\n");
  printf("#* Tomas Lusk, Michal Simek (C) 2005 *#\n");
  printf("#*************************************#\n");
  printf("\n# This file is generated automatically by macro_gen\n# !!! don't edit this file !!!\n\n");

  // create PRINT_GRx
  for(int i = 0; i < 4; i++) GRset(i, i*32, 32);
  
  // create PRINT_Rxx
  for(int i = 0; i < 128; i++) Rone(i);
    
  // create PRINT_Fxx_D
  for(int i = 0; i < 128; i++) FoneD(i);

  // create PRINT_Fxx_S
  for(int i = 0; i < 128; i++) FoneS(i);
    
  return 0; 
}
