/*************************************/
/* Tomas Lusk, Michal Simek (C) 2005 */
/*************************************/

#ifndef _PRINTERS_H_
#define _PRINTERS_H_

#include "printlib.h"

enum PrintMode_e { M_HEX, M_DEC, M_UDEC };

std::string int64_to_str(int64 i, PrintMode_e mode = M_DEC)
{
  if(mode == M_HEX)
  {
    char buf[500];
    unsigned char *p = (unsigned char *)&i;
    sprintf(buf,"%02x%02x%02x%02x%02x%02x%02x%02x",
//      p[7],p[6],p[5],p[4],p[3],p[2],p[1],p[0]); // little-endian
      p[0],p[1],p[2],p[3],p[4],p[5],p[6],p[7]); // big-endian
    return buf;
  }
  return "ERR";
}

std::string int_to_str(int i, PrintMode_e mode = M_DEC, const char *format = 0)
{
  char buf[500];
  const char *f;
  
  if(mode == M_DEC) f = "%d";
  else if(mode == M_UDEC) f = "%u";
  else f = "%x";
  if(format) f = format;
  
  sprintf(buf, f, i);
  return buf;
}

std::string format_str(const std::string &s1, const std::string &s2, const char *format)
{
  char buf[1000];
  sprintf(buf, format, s1.c_str(), s2.c_str());
  return buf;
}


////
class P_GRset : public Printer
{
  int c, i;
  std::string p;
public:
  P_GRset(int count, int index, const std::string &prefix) 
    { c = count; i = index; p = prefix; }

  void Write(Writer &output)
  {
    int num = 1; // number of items per line
    int item_len = 23; // length of one item
    for(int width = output.Width(); (2*num*item_len) <= width; num *= 2 ) ;
    
    for(int index = 0; index < c; index++)
    {
      if( index>0 && index%num == 0 ) output.Write("\n"); // new line
       
      output.Write( format_str( p + int_to_str(index+i), 
        int64_to_str(dat[index+1],M_HEX), "%4s: %s "));
    }
    
    output.Write("\n");
/*  
    name = p + int_to_str(i+index);
    value = i2s(dat[index+1],"%016lx");
char buf[100];
  sprintf(buf,"%08lx%08lx",dat[index+1]>>32,dat[index+1]);
  value = std::string(buf);
    format = def_format;
    */
  }
};


////
struct P_NL : public Printer
{
  void Write(Writer &output)
    { output.Write("\n"); }
};

////
struct P_HR : public Printer
{
  void Write(Writer &output)
  { 
    int width = output.Width();
    while(width-- > 0) output.Write("-");
    output.Write("\n");
  }
};


////
struct P_Rone : public Printer
{
  void Write(Writer &output)
  {
    output.Write( format_str( std::string("r") + int_to_str(dat[1]),
      int64_to_str(dat[2],M_HEX), "%4s: %s\n"));
  }
};


////
struct P_FoneE : public Printer
{
  void Write(Writer &output)
  {
    char buf[200];
    sprintf(buf,"%16f",dat[2]);
    output.Write( format_str( std::string("f") + int_to_str(dat[1]),
      std::string(buf), "%4s: %s\n"));
  }
};


////
struct P_FoneD : public Printer
{
  void Write(Writer &output)
  {
    char buf[200];
    sprintf(buf,"%16f",dat[2]);
    output.Write( format_str( std::string("f") + int_to_str(dat[1]),
      std::string(buf), "%4s: %s\n"));
  }
};


////
struct P_FoneS : public Printer
{
  void Write(Writer &output)
  {
    char buf[200];
    sprintf(buf,"%16f",*(float *)&dat[2]);
    output.Write( format_str( std::string("f") + int_to_str(dat[1]),
      std::string(buf), "%4s: %s\n"));
  }
};


#endif
