        .MODEL small
        .STACK 100h

     ; =======================================================================
     ; Uloha c.5
	 ;
	 ; Automaticke rizeni krizovatky normalni zpusobem (t.j. vzdy v jednom 
	 ; a potom ve druhem smeru) vcetne odbocovacich sipek vpravo. 
	 ; Odbocovaci sipka umozni odboceni v posledni fazi cervene v danem smeru.
	 ; Tlacitko simuluje pozadavek chodcu na prechod. Po stisku tlacitka 
	 ; je dokoncem cyklus a signaly krizovatky se nastavi tak, aby mohli
	 ; prechazet hodci po obou rovnobeznych prechodech.
	 ; 
	 ; Pozn.: prodleva pro chodce alespon 5s.
     ; =======================================================================

        .CODE
		
auta     dw     0111011111011101b       ; VZ=Cervena       SJ=Zelena
         dw     0110011011011101b		; VZ=Cervena+sipka SJ=Zelena
		 dw     0011001110111011b       ; VZ=Cervena+zluta SJ=zluta
         dw     1101110101110111b       ; VZ=Zelena        SJ=Cernena
		 dw		1101110101100110b       ; VZ=Zelena        SJ=Cernena+sipka
         dw     1011101100110011b       ; VZ=zluta         SJ=Cervena+zluta
         ;      CzZOCzZOCzZOCzZO        (O=Odboceni_doprava)
         ;      < Z>< V>< S>< J>

chodci   db		10100101b				; SJ=Cervena	VZ=Zelena
		 db		01011010b				; SJ=Zelena		VZ=Cervena
		 db		01010101b				; SJ=Cervena    VZ=Cervena

tlac	 db		00011000b				; maska tlacitka SJ
		 db		01100000b				; maska tlacitka ZV


start:   mov  si,0                      ; Zacatek hlavniho programu
		 mov  di,0
dalsi:   mov  ax,auta[si]				; Nacteni slova z tabulky
         call vsend                     ; Odeslani na semafor pro vozidla
         push ax
         mov  al,chodci[di]
         call vsend						; Odeslani na semafor pro chodce
         pop  ax
         mov  cx,5000h                  ; Pocet pruchodu cekaci smyckou = prodleva pro chodce
         call delay                     ; Cekani

		 mov  ah,30						; Nastaveni pocku kontrol zmacknuti tlacitka 
cekej:	 mov  cx,100h					; Cekani
         call delay
		 call nacti						; Nacte tlacitka do AL
		 and  al,tlac[di]				; vymaskovani tlacitek
		 cmp  al,tlac[di]				
		 jnz  zmena						; Zmacknuto tlacitko u prechodu kde je Cervena
		 dec ah
		 jnz cekej
		 	

         add  si,2                      ; Uprava indexregistru - odbocovaci spika
         mov  ax,auta[si]
         call vsend
         mov  cx,1000h
         call delay
         sub  si,2
         
zmena:	 add  si,4						; Priprava na zmenu jizdy na krizovatce
         mov  ax,auta[si]
         call vsend
         push ax
         mov  al,chodci[2]				; Vsude na prechodu bude cervena
         call vsend						; Odeslani na semafor pro chodce
         pop  ax
         
         add  si,2
         add  di,1
         cmp  si,12                     ; Uz jsme odeslali vsech 6 slov?
         jnz  dalsi                     ; ... ne, nacteme dalsi
         jmp  start                     ; ... ano, zpet na zacatek



delay:   push ax                        ; Aktivni cekani
vnejsi:  mov  ax,0ffffh
vnitrni: dec  ax
         jnz  vnitrni
         loop vnejsi
         pop  ax
         ret


vsend:                                  ; Vyslani 16-ti bitove hodnoty z AX
         mov  dx,378h                   ; Adresa vystupni brany LPT1:
         mov  cx,10h                    ; Citac pruchodu
vcykl:   ror  ax,1						; Vlastni cykl pro vyslani obsahu AX
         jc   vjedna					; Bit k odeslani = 1?
         call vsend0                    ; ... ne, vysli 0
         jmp  vskip                    
vjedna:  call vsend1                    ; ... ano, vysli 1
vskip:   loop vcykl                     ; a pokracuj s dalsi rotaci AX
         ret

vsend0:  push ax                        ; Zapis hodnoty 0 do pos. registru
         mov  al,0                      ; Data=0, hodiny=0
         out  dx,al
         mov  al,2                      ; Data=0, hodiny=1 (nabezna hrana)
         out  dx,al
         pop  ax
         ret

vsend1:  push ax                        ; Zapis hodnoty 1 do pos. registru
         mov  al,1                      ; Data=1, hodiny=0
         out  dx,al
         mov  al,3                      ; Data=1, hodiny=1 (nabezna hrana)
         out  dx,al
         pop  ax
         ret

nacti:	 push ax
		 mov  al,04h					; konstanta pro cteni tlacitek	
		 mov  dx,378h					; nastaveni vystupni brany
		 out  dx,al	
		 mov  dx,379h
		 in   al,dx						; nacteni stavu tlacitek do AL
		 pop  ax
		 ret


         END start
